/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import java.util.List;
import java.util.Map;
import net.luckperms.api.query.meta.MetaValueSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleMetaValueSelector
implements MetaValueSelector {
    private final Map<String, Strategy> strategies;
    private final Strategy defaultStrategy;

    public SimpleMetaValueSelector(Map<String, Strategy> strategies, Strategy defaultStrategy) {
        this.strategies = strategies;
        this.defaultStrategy = defaultStrategy;
    }

    @Override
    public @NonNull String selectValue(@NonNull String key, @NonNull List<String> values) {
        switch (values.size()) {
            case 0: {
                throw new IllegalArgumentException("values is empty");
            }
            case 1: {
                return values.get(0);
            }
        }
        return this.strategies.getOrDefault(key, this.defaultStrategy).select(values);
    }

    private static String selectNumber(List<String> values, DoubleSelectionPredicate selection) {
        double current = 0.0;
        String selected = null;
        for (String value : values) {
            try {
                double parse = Double.parseDouble(value);
                if (selected != null && !selection.shouldSelect(parse, current)) continue;
                selected = value;
                current = parse;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return selected != null ? selected : Strategy.INHERITANCE.select(values);
    }

    @FunctionalInterface
    private static interface DoubleSelectionPredicate {
        public boolean shouldSelect(double var1, double var3);
    }

    public static enum Strategy {
        INHERITANCE{

            @Override
            public String select(List<String> values) {
                return values.get(0);
            }
        }
        ,
        HIGHEST_NUMBER{
            private final DoubleSelectionPredicate selection = (value, current) -> value > current;

            @Override
            public String select(List<String> values) {
                return SimpleMetaValueSelector.selectNumber(values, this.selection);
            }
        }
        ,
        LOWEST_NUMBER{
            private final DoubleSelectionPredicate selection = (value, current) -> value < current;

            @Override
            public String select(List<String> values) {
                return SimpleMetaValueSelector.selectNumber(values, this.selection);
            }
        };


        public abstract String select(List<String> var1);

        public static Strategy parse(String s) {
            try {
                return Strategy.valueOf(s.replace('-', '_').toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

