/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.api.implementation.ApiActionLog;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.actionlog.ActionLog;
import net.luckperms.api.actionlog.ActionLogger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiActionLogger
implements ActionLogger {
    private final LuckPermsPlugin plugin;

    public ApiActionLogger(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public @NonNull Action.Builder actionBuilder() {
        return LoggedAction.build();
    }

    @Override
    public @NonNull CompletableFuture<ActionLog> getLog() {
        return this.plugin.getStorage().getLog().thenApply(ApiActionLog::new);
    }

    @Override
    public @NonNull CompletableFuture<Void> submit(@NonNull Action entry) {
        return CompletableFuture.runAsync(() -> this.plugin.getLogDispatcher().dispatchFromApi((LoggedAction)entry), this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public @NonNull CompletableFuture<Void> submitToStorage(@NonNull Action entry) {
        return this.plugin.getStorage().logAction(entry);
    }

    @Override
    public @NonNull CompletableFuture<Void> broadcastAction(@NonNull Action entry) {
        return CompletableFuture.runAsync(() -> this.plugin.getLogDispatcher().broadcastFromApi((LoggedAction)entry), this.plugin.getBootstrap().getScheduler().async());
    }
}

