/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.mcsimonflash.sponge.activetime.commands.Base;
import com.mcsimonflash.sponge.activetime.commands.Check;
import com.mcsimonflash.sponge.activetime.managers.Config;
import com.mcsimonflash.sponge.activetime.managers.NucleusIntegration;
import com.mcsimonflash.sponge.activetime.managers.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="activetime", name="ActiveTime", version="1.4.3", dependencies={@Dependency(id="nucleus", optional=true)}, authors={"Simon_Flash"})
public class ActiveTime {
    private static ActiveTime instance;
    @Inject
    private PluginContainer container;
    @Inject
    private Logger logger;
    private URL ore;
    private URL discord;
    private boolean nucleusEnabled;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path directory;

    public Path getDirectory() {
        return this.directory;
    }

    @Listener
    public void onInit(GameInitializationEvent event) {
        instance = this;
        this.logger.info("+=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=+");
        this.logger.info("|     ActiveTime -- Version 1.4.3     |");
        this.logger.info("|      Developed By: Simon_Flash      |");
        this.logger.info("+=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=+");
        Util.initialize();
        try {
            this.ore = new URL("https://ore.spongepowered.org/Simon_Flash/ActiveTime");
            this.discord = new URL("https://discordapp.com/invite/4wayq37");
        }
        catch (MalformedURLException ignored) {
            this.logger.error("Unable to locate ActiveTime Wiki / Support Discord!");
        }
        Sponge.getCommandManager().register((Object)instance, (CommandCallable)Base.SPEC, (List)Lists.newArrayList((Object[])new String[]{"activetime", "atime"}));
        Sponge.getCommandManager().register((Object)instance, (CommandCallable)Check.SPEC, (List)Lists.newArrayList((Object[])new String[]{"ontime", "playtime"}));
    }

    @Listener
    public void onStart(GameStartedServerEvent event) {
        if (Sponge.getPluginManager().isLoaded("nucleus")) {
            if (NucleusIntegration.SERVICE != null) {
                this.nucleusEnabled = true;
                NucleusIntegration.registerMessageToken();
            } else {
                ActiveTime.getLogger().error("Unable to obtain the Nucleus AFK Service - please ensure the AFK module is enabled. AFK times will not be logged.");
            }
        } else {
            ActiveTime.getLogger().warn("Nucleus is not installed on this server. AFK times will not be logged.");
        }
        Util.startTasks();
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        Util.initialize();
        Util.startTasks();
    }

    @Listener
    public void onClientConnect(ClientConnectionEvent.Join event, @Root Player player) {
        Util.startNameTask(player);
        if (Config.limitInt > 0) {
            Util.createTask("ActiveTime CheckPlayerLimit Async Processor", task -> Util.checkLimit(player), 0, false);
        }
    }

    public static ActiveTime getInstance() {
        return instance;
    }

    public static PluginContainer getContainer() {
        return ActiveTime.instance.container;
    }

    public static Logger getLogger() {
        return ActiveTime.instance.logger;
    }

    public static URL getOre() {
        return ActiveTime.instance.ore;
    }

    public static URL getDiscord() {
        return ActiveTime.instance.discord;
    }

    public static boolean isNucleusEnabled() {
        return ActiveTime.instance.nucleusEnabled;
    }
}

