/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cubex2.cs4.api.SlotProvider;
import cubex2.cs4.plugins.vanilla.ContentGuiContainer;
import cubex2.cs4.plugins.vanilla.crafting.SlotItemHandlerCrafting;
import cubex2.cs4.plugins.vanilla.gui.ContainerCS4;
import cubex2.cs4.plugins.vanilla.gui.FluidDisplay;
import cubex2.cs4.plugins.vanilla.gui.FluidSource;
import cubex2.cs4.plugins.vanilla.gui.ItemHandlerSupplier;
import cubex2.cs4.plugins.vanilla.gui.ShiftClickRule;
import cubex2.cs4.plugins.vanilla.gui.SlotData;
import cubex2.cs4.plugins.vanilla.gui.SlotItemHandlerReadOnly;
import cubex2.cs4.plugins.vanilla.tileentity.FieldSupplier;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ContainerGui
extends ContainerCS4 {
    private final ContentGuiContainer content;
    private final ItemHandlerSupplier supplier;
    private final IItemHandler playerInv;
    private final Multimap<SlotData, Slot> slotMap = HashMultimap.create();
    private final Multimap<String, Slot> slotsBySource = HashMultimap.create();
    private final FieldSupplier fieldSupplier;
    private final int[] prevFieldValues;

    public ContainerGui(ContentGuiContainer content, ItemHandlerSupplier supplier, FluidSource fluidSource, FieldSupplier fieldSupplier, EntityPlayer player, int readOnlyPlayerSlot) {
        this.content = content;
        this.supplier = supplier;
        this.fieldSupplier = fieldSupplier;
        this.prevFieldValues = new int[fieldSupplier.getFieldCount()];
        this.playerInv = new PlayerMainInvWrapper(player.field_71071_by);
        for (SlotData data : content.slots) {
            Optional<IItemHandler> inv = this.getInventory(data.name);
            if (!inv.isPresent()) continue;
            IItemHandler handler = inv.get();
            for (int row = 0; row < data.rows; ++row) {
                for (int col = 0; col < data.columns; ++col) {
                    int index = data.getSlotIndex(row, col);
                    int x = data.getX(col);
                    int y = data.getY(row);
                    Object slot = handler instanceof SlotProvider ? ((SlotProvider)handler).createSlot(index, x, y).orElseGet(() -> new SlotItemHandler(handler, index, x, y)) : (handler == this.playerInv && index == readOnlyPlayerSlot ? new SlotItemHandlerReadOnly(handler, index, x, y) : new SlotItemHandler(handler, index, x, y));
                    this.addSlot(data, (Slot)slot);
                }
            }
        }
        for (FluidDisplay display : content.fluidDisplays) {
            IFluidTank tank = fluidSource.getFluidTank(display.source);
            if (tank == null) continue;
            this.addTank(tank);
        }
    }

    public Collection<Slot> getSlotsForSource(String source) {
        return this.slotsBySource.get((Object)source);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            for (int id = 0; id < this.prevFieldValues.length; ++id) {
                if (this.prevFieldValues[id] == this.fieldSupplier.getField(id)) continue;
                listener.func_71112_a((Container)this, id, this.fieldSupplier.getField(id));
            }
        }
        for (int id = 0; id < this.prevFieldValues.length; ++id) {
            this.prevFieldValues[id] = this.fieldSupplier.getField(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.fieldSupplier.setField(id, data);
    }

    private void addSlot(SlotData data, Slot slot) {
        this.func_75146_a(slot);
        this.slotsBySource.put((Object)data.name, (Object)slot);
        this.slotMap.put((Object)data, (Object)slot);
    }

    private Optional<IItemHandler> getInventory(String name) {
        if (name.equals("player")) {
            return Optional.of(this.playerInv);
        }
        return this.supplier.getItemHandler(name);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.field_70170_p.field_72995_K) {
            for (SlotData data : this.content.slots) {
                if (!data.dropOnClose) continue;
                Collection slots = this.slotMap.get((Object)data);
                for (Slot slot : slots) {
                    ItemStack stack = slot.func_75209_a(Integer.MAX_VALUE);
                    if (stack.func_190926_b()) continue;
                    playerIn.func_71019_a(stack, false);
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            boolean ruleApplied = false;
            for (ShiftClickRule rule : this.content.shiftClickRules) {
                if (!rule.canApply(index, itemstack1)) continue;
                ruleApplied = true;
                if (this.func_75135_a(itemstack1, rule.getToStart(), rule.getToEnd() + 1, rule.reverseDirection())) break;
                return ItemStack.field_190927_a;
            }
            if (!ruleApplied) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            SlotItemHandlerCrafting.shiftClick = true;
            slot.func_190901_a(player, itemstack1);
            SlotItemHandlerCrafting.shiftClick = false;
        }
        return itemstack;
    }
}

