/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.proxy;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.blocks.Models.BakedModelLoader;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.common.entities.BlockBuildEntityRender;
import com.direwolf20.buildinggadgets.common.entities.ConstructionBlockEntity;
import com.direwolf20.buildinggadgets.common.entities.ConstructionBlockEntityRender;
import com.direwolf20.buildinggadgets.common.entities.ModEntities;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.proxy.CommonProxy;
import com.direwolf20.buildinggadgets.common.tools.PasteContainerMeshDefinition;
import com.direwolf20.buildinggadgets.common.tools.ToolRenders;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        ModEntities.initModels();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new BakedModelLoader());
        super.preInit(e);
    }

    @Override
    public void init() {
        super.init();
        KeyBindings.init();
        ModBlocks.initColorHandlers();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModBlocks.effectBlock.initModel();
        ModBlocks.templateManager.initModel();
        ModItems.gadgetBuilding.initModel();
        ModItems.gadgetExchanger.initModel();
        ModItems.gadgetCopyPaste.initModel();
        ModItems.template.initModel();
        if (SyncedConfig.enableDestructionGadget) {
            ModItems.gadgetDestruction.initModel();
        }
        if (SyncedConfig.enablePaste) {
            ModItems.constructionPaste.initModel();
            ModItems.constructionChunkDense.initModel();
            ModItems.constructionPasteContainer.initModel();
            ModItems.constructionPasteContainert2.initModel();
            ModItems.constructionPasteContainert3.initModel();
            ModItems.constructionPasteContainerCreative.initModel();
            ModBlocks.constructionBlockDense.initModel();
            ModBlocks.constructionBlock.initModel();
            ModBlocks.constructionBlockPowder.initModel();
            ModelLoader.setCustomMeshDefinition((Item)ModItems.constructionPasteContainer, (ItemMeshDefinition)new PasteContainerMeshDefinition());
            ModelLoader.setCustomMeshDefinition((Item)ModItems.constructionPasteContainert2, (ItemMeshDefinition)new PasteContainerMeshDefinition());
            ModelLoader.setCustomMeshDefinition((Item)ModItems.constructionPasteContainert3, (ItemMeshDefinition)new PasteContainerMeshDefinition());
        }
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(BlockBuildEntity.class, (IRenderFactory)new BlockBuildEntityRender.Factory());
        RenderingRegistry.registerEntityRenderingHandler(ConstructionBlockEntity.class, (IRenderFactory)new ConstructionBlockEntityRender.Factory());
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack heldItem = GadgetGeneric.getGadget((EntityPlayer)player);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (heldItem.func_77973_b() instanceof GadgetBuilding) {
            ToolRenders.renderBuilderOverlay(evt, (EntityPlayer)player, heldItem);
        } else if (heldItem.func_77973_b() instanceof GadgetExchanger) {
            ToolRenders.renderExchangerOverlay(evt, (EntityPlayer)player, heldItem);
        } else if (heldItem.func_77973_b() instanceof GadgetCopyPaste) {
            ToolRenders.renderPasteOverlay(evt, (EntityPlayer)player, heldItem);
        } else if (heldItem.func_77973_b() instanceof GadgetDestruction) {
            ToolRenders.renderDestructionOverlay(evt, (EntityPlayer)player, heldItem);
        }
    }

    @SubscribeEvent
    public static void registerSprites(TextureStitchEvent.Pre event) {
        ClientProxy.registerSprite(event, "buildinggadgets:gui/slot_copypastetool");
        ClientProxy.registerSprite(event, "buildinggadgets:gui/slot_template");
    }

    private static void registerSprite(TextureStitchEvent.Pre event, String loc) {
        event.getMap().func_174942_a(new ResourceLocation(loc));
    }

    public static void playSound(SoundEvent sound, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)pitch));
    }

    public static Color getColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

