/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.commands;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.main.TotalEconomy;
import com.erigitic.shops.Shop;
import com.erigitic.shops.ShopItem;
import com.erigitic.shops.ShopManager;
import com.erigitic.shops.data.ShopData;
import com.erigitic.shops.data.ShopItemData;
import com.erigitic.shops.data.ShopKeys;
import com.erigitic.util.InventoryUtils;
import com.erigitic.util.MessageManager;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.carrier.Chest;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.translation.Translation;

public class ShopCommand
implements CommandExecutor {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private ShopManager shopManager;
    private MessageManager messageManager;

    public ShopCommand(TotalEconomy totalEconomy, AccountManager accountManager, ShopManager shopManager, MessageManager messageManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.shopManager = shopManager;
        this.messageManager = messageManager;
    }

    public CommandSpec getCommandSpec() {
        Stock shopStockCommand = new Stock();
        Buy shopBuyCommand = new Buy();
        return CommandSpec.builder().child((CommandCallable)shopStockCommand.getCommandSpec(), new String[]{"stock", "s"}).child((CommandCallable)shopBuyCommand.getCommandSpec(), new String[]{"buy", "b"}).permission("totaleconomy.command.shop").executor((CommandExecutor)this).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        return CommandResult.success();
    }

    private boolean isTileEntityAChest(TileEntity tileEntity) {
        BlockType blockType = tileEntity.getBlock().getType();
        return blockType == BlockTypes.CHEST;
    }

    private class Buy
    implements CommandExecutor {
        public CommandSpec getCommandSpec() {
            return CommandSpec.builder().description((Text)Text.of((String)"Buy a chest shop")).permission("totaleconomy.command.shop.buy").executor((CommandExecutor)this).build();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            TileEntity tileEntity;
            Player player = (Player)((Player)src).getPlayer().get();
            Optional<TileEntity> tileEntityOpt = ShopCommand.this.shopManager.getTileEntityFromPlayerRaycast(player);
            if (!tileEntityOpt.isPresent() || !ShopCommand.this.isTileEntityAChest(tileEntity = tileEntityOpt.get())) return CommandResult.success();
            Chest chest = (Chest)tileEntity;
            BlockSnapshot blockSnapshot = chest.getLocation().createSnapshot();
            Optional creatorOpt = blockSnapshot.getCreator();
            if (chest.getDoubleChestInventory().isPresent()) {
                throw new CommandException(ShopCommand.this.messageManager.getMessage("command.shop.buy.doublechest"));
            }
            if (chest.get(ShopKeys.SINGLE_SHOP).isPresent()) throw new CommandException(ShopCommand.this.messageManager.getMessage("command.shop.buy.alreadypurchased"));
            if (!creatorOpt.isPresent()) throw new CommandException(ShopCommand.this.messageManager.getMessage("command.shop.buy.notowner"));
            UUID creatorUniqueId = (UUID)creatorOpt.get();
            if (!player.getUniqueId().equals(creatorUniqueId)) throw new CommandException(ShopCommand.this.messageManager.getMessage("command.shop.buy.notowner"));
            if (!this.isChestEmpty(chest)) throw new CommandException(ShopCommand.this.messageManager.getMessage("command.shop.buy.notempty"));
            TEAccount account = (TEAccount)ShopCommand.this.accountManager.getOrCreateAccount(creatorUniqueId).get();
            Cause cause = Cause.builder().append((Object)player).append((Object)ShopCommand.this.totalEconomy.getPluginContainer()).build(EventContext.empty());
            TransactionResult transactionResult = account.withdraw(ShopCommand.this.totalEconomy.getDefaultCurrency(), BigDecimal.valueOf(ShopCommand.this.shopManager.getChestShopPrice()), cause);
            if (transactionResult.getResult().equals((Object)ResultType.SUCCESS)) {
                Shop shop = this.createShopFromPlayer(player);
                chest.offer(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextStyles.BOLD, TextColors.BLUE, shop.getTitle()}));
                chest.offer((ValueContainer)new ShopData(shop));
                player.sendMessage(ShopCommand.this.messageManager.getMessage("command.shop.buy.success"));
                return CommandResult.success();
            } else {
                HashMap<String, String> messageValues = new HashMap<String, String>();
                messageValues.put("price", ShopCommand.this.totalEconomy.getDefaultCurrency().format(BigDecimal.valueOf(ShopCommand.this.shopManager.getChestShopPrice())).toPlain());
                throw new CommandException(ShopCommand.this.messageManager.getMessage("command.shop.buy.insufficientfunds", messageValues));
            }
        }

        private boolean isChestEmpty(Chest chest) {
            int totalItems = chest.getInventory().totalItems();
            return totalItems <= 0;
        }

        private Shop createShopFromPlayer(Player player) {
            Shop shop = new Shop(player.getUniqueId(), ((Text)player.getDisplayNameData().displayName().get()).toPlain() + "'s Shop");
            return shop;
        }
    }

    private class Stock
    implements CommandExecutor {
        public CommandSpec getCommandSpec() {
            return CommandSpec.builder().description((Text)Text.of((String)"Stock a shop with the currently held item")).permission("totaleconomy.command.shop.stock").executor((CommandExecutor)this).arguments(new CommandElement[]{GenericArguments.integer((Text)Text.of((String)"quantity")), GenericArguments.doubleNum((Text)Text.of((String)"price"))}).build();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            CarriedInventory playerInventory;
            int itemAmountInInventory;
            Chest chest;
            Optional shopOpt;
            TileEntity tileEntity;
            Player player = (Player)((Player)src).getPlayer().get();
            Optional<TileEntity> tileEntityOpt = ShopCommand.this.shopManager.getTileEntityFromPlayerRaycast(player);
            if (!tileEntityOpt.isPresent() || !ShopCommand.this.isTileEntityAChest(tileEntity = tileEntityOpt.get()) || !(shopOpt = (chest = (Chest)tileEntity).get(ShopKeys.SINGLE_SHOP)).isPresent()) return CommandResult.success();
            Optional itemInHandOpt = player.getItemInHand(HandTypes.MAIN_HAND);
            UUID shopOwner = ((Shop)shopOpt.get()).getOwner();
            if (!shopOwner.equals(player.getUniqueId()) || !itemInHandOpt.isPresent()) throw new CommandException(Text.of((Object[])new Object[]{ShopCommand.this.messageManager.getMessage("command.shop.stock.notowner")}));
            ItemStack itemInHand = (ItemStack)itemInHandOpt.get();
            int quantity = (Integer)args.getOne((Text)Text.of((String)"quantity")).get();
            double price = this.clampPrice((Double)args.getOne((Text)Text.of((String)"price")).get(), ShopCommand.this.shopManager.getMinPrice(), ShopCommand.this.shopManager.getMaxPrice());
            if (quantity > itemInHand.getMaxStackQuantity()) {
                quantity = itemInHand.getMaxStackQuantity();
            }
            if ((itemAmountInInventory = InventoryUtils.getItemAmountInInventory((Inventory)(playerInventory = player.getInventory()), itemInHand)) < quantity) throw new CommandException(Text.of((Object[])new Object[]{ShopCommand.this.messageManager.getMessage("command.shop.stock.insufficientitems")}));
            ItemStack preparedItem = this.prepareItemStackForShop(itemInHand, quantity, price);
            Collection rejectedItems = chest.getInventory().offer(preparedItem.copy()).getRejectedItems();
            if (rejectedItems.size() > 0) throw new CommandException(Text.of((Object[])new Object[]{ShopCommand.this.messageManager.getMessage("command.shop.stock.noslots")}));
            InventoryUtils.removeItem((Inventory)playerInventory, itemInHand, quantity);
            HashMap<String, String> messageValues = new HashMap<String, String>();
            messageValues.put("quantity", String.valueOf(quantity));
            messageValues.put("item", ((Text)preparedItem.get(Keys.DISPLAY_NAME).orElse(Text.of((Translation)preparedItem.getTranslation(), (Object[])new Object[0]))).toPlain());
            messageValues.put("price", ShopCommand.this.totalEconomy.getDefaultCurrency().format(BigDecimal.valueOf(price), 2).toPlain());
            player.sendMessage(ShopCommand.this.messageManager.getMessage("command.shop.stock.success", messageValues));
            return CommandResult.success();
        }

        private ItemStack prepareItemStackForShop(ItemStack itemStack, int quantity, double price) {
            ShopItem shopItem = new ShopItem(price);
            ItemStack preparedItem = itemStack.copy();
            preparedItem.setQuantity(quantity);
            preparedItem.offer(Keys.ITEM_LORE, shopItem.getLore(ShopCommand.this.totalEconomy.getDefaultCurrency()));
            preparedItem.offer((ValueContainer)new ShopItemData(shopItem));
            return preparedItem;
        }

        private double clampPrice(double price, double minValue, double maxValue) {
            if (price < minValue) {
                return minValue;
            }
            if (price > maxValue) {
                return maxValue;
            }
            return price;
        }
    }
}

