/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.config.AccessRestriction;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerBusFluidStorage;
import extracells.gui.GuiBusFluidStorage;
import extracells.network.AbstractPacket;
import extracells.part.PartFluidStorage;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class PacketBusFluidStorage
extends AbstractPacket {
    PartFluidStorage part;
    AccessRestriction access;

    public PacketBusFluidStorage() {
    }

    public PacketBusFluidStorage(EntityPlayer _player, AccessRestriction _access, boolean toClient) {
        super(_player);
        this.mode = toClient ? (byte)1 : (byte)2;
        this.access = _access;
    }

    public PacketBusFluidStorage(EntityPlayer _player, PartFluidStorage _part) {
        super(_player);
        this.mode = 0;
        this.player = _player;
        this.part = _part;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.part.sendInformation(this.player);
                break;
            }
            case 1: {
                try {
                    this.handleClient();
                }
                catch (Throwable throwable) {}
                break;
            }
            case 2: {
                Container con = this.player.field_71070_bA;
                if (con == null || !(con instanceof ContainerBusFluidStorage)) break;
                ((ContainerBusFluidStorage)con).part.updateAccess(this.access);
                new PacketBusFluidStorage(this.player, this.access, true).sendPacketToPlayer(this.player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    void handleClient() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null && screen instanceof GuiBusFluidStorage) {
            ((GuiBusFluidStorage)screen).updateAccessRestriction(this.access);
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                this.part = (PartFluidStorage)PacketBusFluidStorage.readPart(in);
                break;
            }
            case 1: 
            case 2: {
                this.access = AccessRestriction.valueOf((String)PacketBusFluidStorage.readString(in));
            }
        }
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                PacketBusFluidStorage.writePart(this.part, out);
                break;
            }
            case 1: 
            case 2: {
                PacketBusFluidStorage.writeString(this.access.name(), out);
            }
        }
    }
}

