/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.progress;

import alexiil.mc.mod.load.CustomLoadingScreen;
import alexiil.mc.mod.load.ModLoadingListener;
import alexiil.mc.mod.load.Translation;
import alexiil.mc.mod.load.progress.LongTermProgressTracker;
import alexiil.mc.mod.load.progress.ProgressSectionInfo;
import alexiil.mc.mod.load.render.MainSplashRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraftforge.fml.common.ProgressManager;

public class SingleProgressBarTracker {
    public static final int MAX_PROGRESS = 0x100000;
    public static final double MAX_PROGRESS_D = 1048576.0;
    private static final int MOD_STAGE_RELOAD = 524288;
    private static final int MOD_STAGE_POST = 943718;
    private static final int MOD_STAGE_COMPLETE = 0x100000;
    private static final int RELOAD_COUNT = ReloadPart.values().length;
    private static int reloadIndex = -1;
    private static ReloadPart reloadPart = null;
    private static boolean isInReload = false;
    private static boolean reachedPost = false;
    private static ProgressManager.ProgressBar lastReloadBar = null;
    private static String status;
    private static String subStatus;
    private static int progress;
    private static final boolean needsLock;
    public static final Lock updateLock;
    private static final LockUnlocker lockUnlocker;
    private static final LockUnlocker no_opUnlocker;
    private static boolean hasExpected;
    private static ProgressSectionInfo[] expected;
    private static final List<ProgressSectionInfo> progressSections;
    private static ProgressSectionInfo currentInfo;

    public static LockUnlocker lockUpdate() {
        if (needsLock) {
            updateLock.lock();
            SingleProgressBarTracker.update();
            return lockUnlocker;
        }
        SingleProgressBarTracker.update();
        return no_opUnlocker;
    }

    private static void update() {
        int diff;
        if (!hasExpected) {
            hasExpected = true;
            LongTermProgressTracker tracker = LongTermProgressTracker.load();
            if (tracker != null && Arrays.equals(tracker.modIds, ModLoadingListener.modIds.toArray(new String[0]))) {
                expected = tracker.infos;
            }
        }
        status = ModLoadingListener.LoaderStage.CONSTRUCT.translate();
        subStatus = "Custom Loading Screen";
        progress = 0;
        ModLoadingListener.ModStage stage = ModLoadingListener.stage;
        boolean hasFinishedModLoad = false;
        if (stage != null) {
            int to;
            int from;
            status = stage.getDisplayText();
            subStatus = stage.getSubDisplayText();
            if (stage.state == ModLoadingListener.LoaderStage.POST_INIT && stage.index == 0) {
                isInReload = false;
                reloadIndex = -1;
                reloadPart = null;
            }
            int parts = 1;
            int part = 0;
            if (!stage.state.isAfterReload1) {
                from = 0;
                to = 524288;
                parts = 4;
                part = stage.state.ordinal();
            } else {
                from = 943718;
                to = 0x100000;
                parts = 2;
                part = stage.state == ModLoadingListener.LoaderStage.LOAD_COMPLETE ? 1 : 0;
                reachedPost = true;
            }
            diff = to - from;
            int subDiff = diff / parts;
            if (diff < 0) {
                diff = 0;
            }
            progress = from + subDiff * part + stage.getSubProgress(subDiff);
            hasFinishedModLoad = stage.getNext() == stage;
        }
        Iterator i = ProgressManager.barIterator();
        ArrayList<String> titles = new ArrayList<String>();
        while (i.hasNext()) {
            ProgressManager.ProgressBar b = (ProgressManager.ProgressBar)i.next();
            String title = b.getTitle();
            titles.add(title);
            ReloadPart part = SingleProgressBarTracker.getReloadPart(titles);
            if (part == null) continue;
            isInReload = true;
            lastReloadBar = b;
            if (reloadPart == part) continue;
            reloadPart = part;
            ++reloadIndex;
        }
        if (isInReload) {
            int from = 524288;
            int to = 943718;
            diff = (to - from) / RELOAD_COUNT;
            progress = from + diff * reloadIndex;
            progress += (lastReloadBar.getStep() + 1) * diff / (lastReloadBar.getSteps() + 1);
            subStatus = lastReloadBar.getMessage();
            if (subStatus.length() > 30) {
                subStatus = subStatus.substring(0, 27) + "...";
            }
            status = SingleProgressBarTracker.reloadPart.translatedTitle;
        } else if (hasFinishedModLoad) {
            progress = 0x100000;
            status = Translation.translate("customloadingscreen.finishing");
        }
        long now = MainSplashRenderer.getTotalTime();
        if (currentInfo != null) {
            if (reloadPart != SingleProgressBarTracker.currentInfo.reloadPart) {
                SingleProgressBarTracker.currentInfo.time = now - SingleProgressBarTracker.currentInfo.time;
                progressSections.add(currentInfo);
                currentInfo = null;
            } else if (!(isInReload || stage == null || stage.state == SingleProgressBarTracker.currentInfo.modState && ModLoadingListener.modIds.get(stage.index) == SingleProgressBarTracker.currentInfo.modId)) {
                SingleProgressBarTracker.currentInfo.time = now - SingleProgressBarTracker.currentInfo.time;
                progressSections.add(currentInfo);
                currentInfo = null;
            }
        }
        if (currentInfo == null) {
            if (reloadPart != null) {
                currentInfo = new ProgressSectionInfo(reloadPart, now);
            } else if (stage != null) {
                String modId = ModLoadingListener.modIds.get(stage.index);
                currentInfo = new ProgressSectionInfo(stage.state, modId, now);
            }
        }
    }

    public static List<ProgressSectionInfo> getProgressSections() {
        if (currentInfo != null) {
            SingleProgressBarTracker.currentInfo.time = MainSplashRenderer.getTotalTime() - SingleProgressBarTracker.currentInfo.time;
            progressSections.add(currentInfo);
            currentInfo = null;
        }
        return progressSections;
    }

    private static ReloadPart getReloadPart(List<String> titles) {
        for (ReloadPart part : ReloadPart.values()) {
            if (!part.matches(titles)) continue;
            return part;
        }
        return null;
    }

    public static String getStatusText() {
        return status;
    }

    public static String getSubStatus() {
        return subStatus;
    }

    public static int getProgress() {
        return progress;
    }

    public static boolean isInReload() {
        return isInReload;
    }

    static {
        needsLock = CustomLoadingScreen.useFrame;
        updateLock = new ReentrantLock(true);
        lockUnlocker = () -> updateLock.unlock();
        no_opUnlocker = () -> {};
        progressSections = new ArrayList<ProgressSectionInfo>();
    }

    public static enum ReloadPart {
        MODEL_LOADER_BAKE("ModelLoader: baking", "modelloader.bake"),
        MODEL_LOADER_BLOCKS("ModelLoader: blocks", "modelloader.blocks"),
        MODEL_LOADER_ITEMS("ModelLoader: items", "modelloader.items"),
        TEXTURE_LOADING("Texture stitching", "texture.load"){

            @Override
            public boolean matches(List<String> titles) {
                for (String s : titles) {
                    if (!"Texture creation".equals(s)) continue;
                    return false;
                }
                return super.matches(titles);
            }
        }
        ,
        TEXTURE_STITCHING("Texture stitching", "texture.stitch"){

            @Override
            public boolean matches(List<String> titles) {
                boolean foundCreation = false;
                for (String s : titles) {
                    if (!"Texture creation".equals(s)) continue;
                    foundCreation = true;
                    break;
                }
                if (!foundCreation) {
                    return false;
                }
                return super.matches(titles);
            }
        };

        public final String barTitle;
        public final String translatedTitle;

        private ReloadPart(String barTitle, String translateKey) {
            this.barTitle = barTitle;
            this.translatedTitle = Translation.translate("customloadingscreen.mcstate." + translateKey);
        }

        public boolean matches(List<String> titles) {
            return titles.get(titles.size() - 1).equals(this.barTitle);
        }
    }

    @FunctionalInterface
    public static interface LockUnlocker
    extends AutoCloseable {
        @Override
        public void close();
    }
}

