/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.dimension;

import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.planets.GCPlanetDimensions;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.ChunkProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.RoomTreasureMars;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderMars
extends WorldProviderSpace
implements IGalacticraftWorldProvider,
ISolarLevel {
    private double solarMultiplier = -1.0;

    @Override
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3(0.8235294f * f, 0.47058824f * f, 0.23137255f * f);
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3(0.6039216f * f, 0.44705883f * f, 0.25882354f * f);
    }

    @Override
    public boolean hasSunset() {
        return false;
    }

    @Override
    public long getDayLength() {
        return 24660L;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderMars.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.75f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 76;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    @Override
    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    @Override
    public float getGravity() {
        return 0.058f;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 0.9;
    }

    @Override
    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 2;
    }

    @Override
    public float getFallDamageModifier() {
        return 0.38f;
    }

    @Override
    public CelestialBody getCelestialBody() {
        return MarsModule.planetMars;
    }

    @Override
    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            this.solarMultiplier = s * s * s;
        }
        return this.solarMultiplier;
    }

    @Override
    public int getDungeonSpacing() {
        return 704;
    }

    public DimensionType func_186058_p() {
        return GCPlanetDimensions.MARS;
    }

    @Override
    public float getArrowGravity() {
        return 0.015f;
    }

    @Override
    public ResourceLocation getDungeonChestType() {
        return RoomTreasureMars.MARSCHEST;
    }

    @Override
    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(MarsBlocks.marsBlock);
        return list;
    }
}

