/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMachineMarsT2
extends BlockMachineBase {
    public static final PropertyEnum<EnumMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockMachineMarsT2(String assetName) {
        super(assetName);
    }

    @Override
    protected void initialiseTypes() {
        this.types = EnumMachineType.values;
        this.typeBase = EnumMachineType.values[0];
    }

    @Override
    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        playerIn.openGui((Object)GalacticraftPlanets.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = this.func_176201_c(state) & 0xC;
        return new ItemStack((Block)this, 1, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGasLiquefier) {
            TileEntityGasLiquefier tileEntity = (TileEntityGasLiquefier)te;
            if (tileEntity.processTicks > 0) {
                float x = (float)pos.func_177958_n() + 0.5f;
                float y = (float)pos.func_177956_o() + 0.8f + 0.05f * (float)rand.nextInt(3);
                float z = (float)pos.func_177952_p() + 0.5f;
                for (float i = -0.41f + 0.16f * rand.nextFloat(); i < 0.5f; i += 0.167f) {
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x + i, y, z - 0.41f), new Vector3(0.0, -0.015, -0.0015), new Object[0]);
                    }
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x + i, y, z + 0.537f), new Vector3(0.0, -0.015, 0.0015), new Object[0]);
                    }
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x - 0.41f, y, z + i), new Vector3(-0.0015, -0.015, 0.0), new Object[0]);
                    }
                    if (rand.nextInt(3) != 0) continue;
                    GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x + 0.537f, y, z + i), new Vector3(0.0015, -0.015, 0.0), new Object[0]);
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumMachineType type = (EnumMachineType)this.typeBase.fromMetadata(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumMachineType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public static enum EnumMachineType implements BlockMachineBase.EnumMachineBase,
    IStringSerializable
    {
        GAS_LIQUEFIER(0, "gas_liquefier", TileEntityGasLiquefier::new, "tile.gas_liquefier.description", "tile.mars_machine.4"),
        METHANE_SYNTHESIZER(4, "methane_synthesizer", TileEntityMethaneSynthesizer::new, "tile.methane_synthesizer.description", "tile.mars_machine.5"),
        ELECTROLYZER(8, "electrolyzer", TileEntityElectrolyzer::new, "tile.electrolyzer.description", "tile.mars_machine.6");

        private final int meta;
        private final String name;
        private final TileConstructor tile;
        private final String shiftDescriptionKey;
        private final String blockName;
        private static final EnumMachineType[] values;

        private EnumMachineType(int meta, String name, TileConstructor tile, String key, String blockName) {
            this.meta = meta;
            this.name = name;
            this.tile = tile;
            this.shiftDescriptionKey = key;
            this.blockName = blockName;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        @Override
        public EnumMachineType fromMetadata(int meta) {
            return values[meta / 4 % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public TileEntity tileConstructor() {
            return this.tile.create();
        }

        @Override
        public String getShiftDescriptionKey() {
            return this.shiftDescriptionKey;
        }

        @Override
        public String getTranslationKey() {
            return this.blockName;
        }

        static {
            values = EnumMachineType.values();
        }

        @FunctionalInterface
        private static interface TileConstructor {
            public TileEntity create();
        }
    }
}

