/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GalacticLog {
    private final Logger logger;

    public GalacticLog(Object modClass) {
        this.logger = LogManager.getLogger((String)modClass.getClass().getSimpleName());
    }

    public void catching(Throwable t) {
        this.logger.catching(t);
    }

    public void debug(String msg, Object ... params) {
        if (ConfigManagerCore.enableDebug) {
            this.logger.debug(msg, params);
        }
    }

    public void error(String msg, Object ... params) {
        this.logger.error(msg, params);
    }

    public void error(Throwable t, String msg) {
        this.logger.error(msg, t);
    }

    public void fatal(String msg, Object ... params) {
        this.logger.fatal(msg, params);
    }

    public void info(String msg, Object ... params) {
        this.logger.info(msg, params);
    }

    public void log(Level level, String msg, Object ... params) {
        this.logger.log(level, msg, params);
    }

    public void trace(String msg, Object ... params) {
        this.logger.trace(msg, params);
    }

    public void warn(String msg, Object ... params) {
        this.logger.warn(msg, params);
    }

    public void warn(Throwable t, String msg, Object ... params) {
        this.logger.warn(msg, params);
        this.logger.catching(t);
    }

    public void noticableWarning(String ... strings) {
        this.noticableWarning(true, (List<String>)ImmutableList.copyOf((Object[])strings));
    }

    public void noticableWarning(Throwable t, String ... strings) {
        this.noticableWarning(true, (List<String>)ImmutableList.copyOf((Object[])strings), t.getStackTrace());
    }

    public void noticableWarningNoTrace(String ... strings) {
        this.noticableWarning(false, (List<String>)ImmutableList.copyOf((Object[])strings));
    }

    private void noticableWarning(boolean trace, List<String> lines) {
        this.noticableWarning(trace, lines, Thread.currentThread().getStackTrace());
    }

    private void noticableWarning(boolean trace, List<String> lines, StackTraceElement[] elements) {
        this.error("********************************************************************************", new Object[0]);
        for (String line : lines) {
            for (String subline : GalacticLog.wrapString(line, 78, false, new ArrayList<String>())) {
                this.error("* " + subline, new Object[0]);
            }
        }
        if (trace) {
            StackTraceElement[] stackTrace = elements;
            for (int i = 2; i < 8 && i < stackTrace.length; ++i) {
                this.warn("*  at {}{}", stackTrace[i].toString(), i == 7 ? "..." : "");
            }
        }
        this.error("********************************************************************************", new Object[0]);
    }

    private static List<String> wrapString(String string, int lnLength, boolean wrapLongWords, List<String> list) {
        String[] lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR);
        Collections.addAll(list, lines);
        return list;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

