/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerServer;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemArmorAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.items.ItemArmorMars;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerServer
implements IPlayerServer {
    private boolean updatingRidden = false;
    static List<EntityPlayer> noClipList = new LinkedList<EntityPlayer>();

    @Override
    public void updateRiddenPre(EntityPlayerMP player) {
        this.updatingRidden = true;
    }

    @Override
    public void updateRiddenPost(EntityPlayerMP player) {
        this.updatingRidden = false;
    }

    @Override
    public boolean dismountEntity(EntityPlayerMP player, Entity par1Entity) {
        return this.updatingRidden && player.func_184187_bx() instanceof IIgnoreShift && ((IIgnoreShift)player.func_184187_bx()).shouldIgnoreShiftExit();
    }

    @Override
    public void move(EntityPlayerMP player, MoverType type, double x, double y, double z) {
        if (player.field_70170_p.field_73011_w instanceof WorldProviderMoon && !player.field_70170_p.field_72995_K && player.func_184187_bx() == null) {
            GCPlayerHandler.updateFeet(player, x, z);
        }
    }

    @Override
    public boolean wakeUpPlayer(EntityPlayerMP player, boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        BlockPos c = player.field_71081_bT;
        if (c != null) {
            EventWakePlayer event = new EventWakePlayer((EntityPlayer)player, c, immediately, updateWorldFlag, setSpawn, false);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.result == null || event.result == EntityPlayer.SleepResult.OK) {
                return false;
            }
        }
        return true;
    }

    @Override
    public float attackEntityFrom(EntityPlayerMP player, DamageSource par1DamageSource, float par2) {
        if (player.func_184187_bx() instanceof EntityCelestialFake) {
            return -1.0f;
        }
        if (GalacticraftCore.isPlanetsLoaded) {
            if (par1DamageSource == DamageSource.field_76380_i) {
                if (player.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) {
                    if (player.field_70163_u > -120.0) {
                        return -1.0f;
                    }
                    if (player.field_70163_u > -180.0) {
                        par2 /= 2.0f;
                    }
                }
            } else if (par1DamageSource == DamageSource.field_76379_h || par1DamageSource == DamageSourceGC.spaceshipCrash) {
                int titaniumCount = 0;
                if (player.field_71071_by != null) {
                    for (ItemStack armorPiece : player.func_184193_aE()) {
                        if (armorPiece == null || !(armorPiece.func_77973_b() instanceof ItemArmorAsteroids)) continue;
                        ++titaniumCount;
                    }
                }
                if (titaniumCount == 4) {
                    titaniumCount = 5;
                }
                par2 = (float)((double)par2 * (1.0 - 0.15 * (double)titaniumCount));
            }
        }
        return par2 == -1.0f ? -0.9999f : par2;
    }

    @Override
    public void knockBack(EntityPlayerMP player, Entity entity, float strength, double impulseX, double impulseZ) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((EntityLivingBase)player, (Entity)entity, (float)strength, (double)impulseX, (double)impulseZ);
        if (event.isCanceled()) {
            return;
        }
        int deshCount = 0;
        if (player.field_71071_by != null && GalacticraftCore.isPlanetsLoaded) {
            for (int i = 0; i < 4; ++i) {
                for (ItemStack armorPiece : player.func_184193_aE()) {
                    if (armorPiece == null || !(armorPiece.func_77973_b() instanceof ItemArmorMars)) continue;
                    ++deshCount;
                }
            }
        }
        if (player.func_70681_au().nextDouble() >= player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            player.field_70160_al = deshCount < 2;
            float f1 = MathHelper.func_76133_a((double)(impulseX * impulseX + impulseZ * impulseZ));
            float f2 = 0.4f - (float)deshCount * 0.05f;
            double d1 = 2.0 - (double)deshCount * 0.15;
            player.field_70159_w /= d1;
            player.field_70181_x /= d1;
            player.field_70179_y /= d1;
            player.field_70159_w -= (double)f2 * impulseX / (double)f1;
            player.field_70181_x += (double)f2;
            player.field_70179_y -= (double)f2 * impulseZ / (double)f1;
            if (player.field_70181_x > 0.4) {
                player.field_70181_x = 0.4;
            }
        }
    }

    @Override
    public boolean isSpectator(EntityPlayerMP player) {
        return noClipList.contains(player);
    }

    @Override
    public void setNoClip(EntityPlayerMP player, boolean noClip) {
        if (noClip) {
            if (!noClipList.contains(player)) {
                noClipList.add((EntityPlayer)player);
            }
        } else {
            noClipList.remove(player);
        }
    }
}

