/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionVehicle;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagVehicleDestroyListener {
    @Listener
    public void onInteract(InteractEntityEvent.Primary event, @First Player player) {
        EntityType type = event.getTargetEntity().getType();
        if (FlagUtils.isVehicle(type)) {
            EnumRegionVehicle vehicle = FlagUtils.getVehicle(type);
            this.handleEvent(event, vehicle, player);
        }
    }

    private void handleEvent(InteractEntityEvent.Primary event, EnumRegionVehicle vehicle, Player player) {
        Region region = RegionUtils.getRegion((Location<World>)player.getLocation());
        if (region != null && vehicle != null) {
            boolean cancel;
            boolean bl = cancel = !region.getVehicleDestroy(vehicle) && !RegionUtils.hasPermission(player, region);
            if (cancel) {
                event.setCancelled(true);
                if (player != null) {
                    MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                }
            }
        }
    }
}

