/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.api.versioning;

import java.util.Objects;
import net.romvoid95.api.versioning.VersionException;

public class Version
implements Comparable<Version> {
    private final String originalValue;
    private final String value;
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final String[] suffixTokens;
    private final String build;
    private final VersionType type;

    public Version() {
        this(null, VersionType.STRICT);
    }

    public Version(String value) {
        this(value, VersionType.STRICT);
    }

    public Version(String value, VersionType type) {
        String[] tmp;
        this.originalValue = value;
        this.type = type;
        this.value = value = value.trim();
        String[] tokens = this.hasPreRelease(value) ? value.split("-", 2) : new String[]{value};
        String build = null;
        Integer minor = null;
        Integer patch = null;
        try {
            String[] mainTokens;
            block20: {
                if (tokens.length == 1) {
                    if (tokens[0].endsWith("+")) {
                        throw new VersionException("The build cannot be empty.");
                    }
                    tmp = tokens[0].split("\\+");
                    mainTokens = tmp[0].split("\\.");
                    if (tmp.length == 2) {
                        build = tmp[1];
                    }
                } else {
                    mainTokens = tokens[0].split("\\.");
                }
                try {
                    this.major = Integer.valueOf(mainTokens[0]);
                }
                catch (NumberFormatException e) {
                    throw new VersionException("Invalid version (no major version): " + value);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new VersionException("Invalid version (no major version): " + value);
                }
                try {
                    minor = Integer.valueOf(mainTokens[1]);
                }
                catch (IndexOutOfBoundsException e) {
                    if (type != VersionType.STRICT) break block20;
                    throw new VersionException("Invalid version (no minor version): " + value);
                }
            }
            try {
                patch = Integer.valueOf(mainTokens[2]);
            }
            catch (IndexOutOfBoundsException e) {
                if (type == VersionType.STRICT) {
                    throw new VersionException("Invalid version (no patch version): " + value);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new VersionException("The version is invalid: " + value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new VersionException("The version is invalid: " + value);
        }
        this.minor = minor;
        this.patch = patch;
        String[] suffix = new String[]{};
        try {
            if (tokens[1].endsWith("+")) {
                throw new VersionException("The build cannot be empty.");
            }
            tmp = tokens[1].split("\\+");
            if (tmp.length == 2) {
                suffix = tmp[0].split("\\.");
                build = tmp[1];
            } else {
                suffix = tokens[1].split("\\.");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.suffixTokens = suffix;
        this.build = build;
        this.validate(type);
    }

    private void validate(VersionType type) {
        if (this.minor == null && type == VersionType.STRICT) {
            throw new VersionException("Invalid version (no minor version): " + this.value);
        }
        if (this.patch == null && type == VersionType.STRICT) {
            throw new VersionException("Invalid version (no patch version): " + this.value);
        }
    }

    private boolean hasPreRelease(String version) {
        int firstIndexOfPlus = this.value.indexOf("+");
        int firstIndexOfHyphen = this.value.indexOf("-");
        if (firstIndexOfHyphen == -1) {
            return false;
        }
        return firstIndexOfPlus == -1 || firstIndexOfHyphen < firstIndexOfPlus;
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(new Version(version, this.getType()));
    }

    public boolean isGreaterThan(Version version) {
        int otherPatch;
        int otherMinor;
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMajor() < version.getMajor()) {
            return false;
        }
        int n = otherMinor = version.getMinor() != null ? version.getMinor() : 0;
        if (this.getMinor() != null && this.getMinor() > otherMinor) {
            return true;
        }
        if (this.getMinor() != null && this.getMinor() < otherMinor) {
            return false;
        }
        int n2 = otherPatch = version.getPatch() != null ? version.getPatch() : 0;
        if (this.getPatch() != null && this.getPatch() > otherPatch) {
            return true;
        }
        if (this.getPatch() != null && this.getPatch() < otherPatch) {
            return false;
        }
        String[] tokens1 = this.getSuffixTokens();
        String[] tokens2 = version.getSuffixTokens();
        if (tokens1.length == 0 && tokens2.length > 0) {
            return true;
        }
        if (tokens2.length == 0 && tokens1.length > 0) {
            return false;
        }
        for (int i = 0; i < tokens1.length && i < tokens2.length; ++i) {
            int cmp;
            try {
                int t1 = Integer.valueOf(tokens1[i]);
                int t2 = Integer.valueOf(tokens2[i]);
                cmp = t1 - t2;
            }
            catch (NumberFormatException e) {
                cmp = tokens1[i].compareToIgnoreCase(tokens2[i]);
            }
            if (cmp < 0) {
                return false;
            }
            if (cmp <= 0) continue;
            return true;
        }
        return tokens1.length > tokens2.length;
    }

    public boolean isGreaterThanOrEqualTo(String version) {
        return this.isGreaterThanOrEqualTo(new Version(version, this.type));
    }

    public boolean isGreaterThanOrEqualTo(Version version) {
        return this.isGreaterThan(version) || this.isEquivalentTo(version);
    }

    public boolean isLowerThan(String version) {
        return this.isLowerThan(new Version(version, this.type));
    }

    public boolean isLowerThan(Version version) {
        return !this.isGreaterThan(version) && !this.isEquivalentTo(version);
    }

    public boolean isLowerThanOrEqualTo(String version) {
        return this.isLowerThanOrEqualTo(new Version(version, this.type));
    }

    public boolean isLowerThanOrEqualTo(Version version) {
        return !this.isGreaterThan(version);
    }

    public boolean isEquivalentTo(String version) {
        return this.isEquivalentTo(new Version(version, this.type));
    }

    public boolean isEquivalentTo(Version version) {
        Version sem1 = this.getBuild() == null ? this : new Version(this.getValue().replace("+" + this.getBuild(), ""));
        Version sem2 = version.getBuild() == null ? version : new Version(version.getValue().replace("+" + version.getBuild(), ""));
        return sem1.isEqualTo(sem2);
    }

    public boolean isEqualTo(String version) {
        return this.isEqualTo(new Version(version, this.type));
    }

    public boolean isEqualTo(Version version) {
        return this.equals(version);
    }

    public boolean isStable() {
        return this.getMajor() != null && this.getMajor() > 0 && (this.getSuffixTokens() == null || this.getSuffixTokens().length == 0);
    }

    public GenericVersionDiff diff(String version) {
        return this.diff(new Version(version, this.type));
    }

    public GenericVersionDiff diff(Version version) {
        if (!Objects.equals(this.major, version.getMajor())) {
            return GenericVersionDiff.MAJOR;
        }
        if (!Objects.equals(this.minor, version.getMinor())) {
            return GenericVersionDiff.MINOR;
        }
        if (!Objects.equals(this.patch, version.getPatch())) {
            return GenericVersionDiff.PATCH;
        }
        if (!this.areSameSuffixes(version.getSuffixTokens())) {
            return GenericVersionDiff.SUFFIX;
        }
        if (!Objects.equals(this.build, version.getBuild())) {
            return GenericVersionDiff.BUILD;
        }
        return GenericVersionDiff.NONE;
    }

    private boolean areSameSuffixes(String[] suffixTokens) {
        if (this.suffixTokens == null && suffixTokens == null) {
            return true;
        }
        if (this.suffixTokens == null || suffixTokens == null) {
            return false;
        }
        if (this.suffixTokens.length != suffixTokens.length) {
            return false;
        }
        for (int i = 0; i < this.suffixTokens.length; ++i) {
            if (this.suffixTokens[i].equals(suffixTokens[i])) continue;
            return false;
        }
        return true;
    }

    public Version toStrict() {
        Integer minor = this.minor != null ? this.minor : 0;
        Integer patch = this.patch != null ? this.patch : 0;
        return Version.create(VersionType.STRICT, this.major, minor, patch, this.suffixTokens, this.build);
    }

    public Version withIncMajor() {
        return this.withIncMajor(1);
    }

    public Version withIncMajor(int increment) {
        return this.withInc(increment, 0, 0);
    }

    public Version withIncMinor() {
        return this.withIncMinor(1);
    }

    public Version withIncMinor(int increment) {
        return this.withInc(0, increment, 0);
    }

    public Version withIncPatch() {
        return this.withIncPatch(1);
    }

    public Version withIncPatch(int increment) {
        return this.withInc(0, 0, increment);
    }

    private Version withInc(int majorInc, int minorInc, int patchInc) {
        Integer minor = this.minor;
        Integer patch = this.patch;
        if (this.minor != null) {
            minor = minor + minorInc;
        }
        if (this.patch != null) {
            patch = patch + patchInc;
        }
        return this.with(this.major + majorInc, minor, patch, true, true);
    }

    public Version withClearedSuffix() {
        return this.with((int)this.major, this.minor, this.patch, false, true);
    }

    public Version withClearedBuild() {
        return this.with((int)this.major, this.minor, this.patch, true, false);
    }

    public Version withClearedSuffixAndBuild() {
        return this.with((int)this.major, this.minor, this.patch, false, false);
    }

    public Version withSuffix(String suffix) {
        return this.with((int)this.major, this.minor, this.patch, suffix.split("\\."), this.build);
    }

    public Version withBuild(String build) {
        return this.with((int)this.major, this.minor, this.patch, this.suffixTokens, build);
    }

    public Version nextMajor() {
        return this.with(this.major + 1, (Integer)0, (Integer)0, false, false);
    }

    public Version nextMinor() {
        return this.with((int)this.major, (Integer)(this.minor + 1), (Integer)0, false, false);
    }

    public Version nextPatch() {
        return this.with((int)this.major, this.minor, (Integer)(this.patch + 1), false, false);
    }

    private Version with(int major, Integer minor, Integer patch, boolean suffix, boolean build) {
        minor = this.minor != null ? minor : null;
        patch = this.patch != null ? patch : null;
        String buildStr = build ? this.build : null;
        String[] suffixTokens = suffix ? this.suffixTokens : null;
        return Version.create(this.type, major, minor, patch, suffixTokens, buildStr);
    }

    private Version with(int major, Integer minor, Integer patch, String[] suffixTokens, String build) {
        minor = this.minor != null ? minor : null;
        patch = this.patch != null ? patch : null;
        return Version.create(this.type, major, minor, patch, suffixTokens, build);
    }

    private static Version create(VersionType type, int major, Integer minor, Integer patch, String[] suffix, String build) {
        StringBuilder sb = new StringBuilder().append(major);
        if (minor != null) {
            sb.append(".").append(minor);
        }
        if (patch != null) {
            sb.append(".").append(patch);
        }
        if (suffix != null) {
            boolean first = true;
            for (String suffixToken : suffix) {
                if (first) {
                    sb.append("-");
                    first = false;
                } else {
                    sb.append(".");
                }
                sb.append(suffixToken);
            }
        }
        if (build != null) {
            sb.append("+").append(build);
        }
        return new Version(sb.toString(), type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.value.equals(version.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(Version version) {
        if (this.isGreaterThan(version)) {
            return 1;
        }
        if (this.isLowerThan(version)) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.getValue();
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public String[] getSuffixTokens() {
        return this.suffixTokens;
    }

    public String getBuild() {
        return this.build;
    }

    public VersionType getType() {
        return this.type;
    }

    public static enum VersionType {
        STRICT,
        LOOSE,
        MC;

    }

    public static enum McVersionDiff {
        MCVERSION,
        MAJORMOD,
        MAJORAPI,
        MINOR,
        PATCH;

    }

    public static enum GenericVersionDiff {
        NONE,
        MAJOR,
        MINOR,
        PATCH,
        SUFFIX,
        BUILD;

    }
}

