/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop;

import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopConfig;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.ShopsLogs;
import com.carrot.carrotshop.command.NoSpamExecutor;
import com.carrot.carrotshop.command.ShopConfigCurrencyExecutor;
import com.carrot.carrotshop.command.ShopConfigExecutor;
import com.carrot.carrotshop.command.ShopConfigReloadExecutor;
import com.carrot.carrotshop.command.ShopImportExecutor;
import com.carrot.carrotshop.command.ShopMainExecutor;
import com.carrot.carrotshop.command.ShopReportExecutor;
import com.carrot.carrotshop.command.ShopServerReportExecutor;
import com.carrot.carrotshop.command.ShopWikiExecutor;
import com.carrot.carrotshop.command.element.CurrencyElement;
import com.carrot.carrotshop.listener.BlockBreakListener;
import com.carrot.carrotshop.listener.PlayerClickListener;
import com.carrot.carrotshop.listener.PlayerConnexionListener;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.text.Text;

@Plugin(id="carrotshop", name="CarrotShop", authors={"Carrot"}, url="https://github.com/TheoKah/CarrotShop")
public class CarrotShop {
    private File rootDir;
    private static CarrotShop plugin;
    @Inject
    private Logger logger;
    @Inject
    @ConfigDir(sharedRoot=true)
    private File defaultConfigDir;
    private EconomyService economyService = null;
    private static List<UUID> noSpam;

    @Listener
    public void onInit(GameInitializationEvent event) throws IOException {
        plugin = this;
        this.rootDir = new File(this.defaultConfigDir, "carrotshop");
        Lang.init(this.rootDir);
        ShopConfig.init(this.rootDir);
        ShopsLogs.init(this.rootDir);
        ShopsData.init(this.rootDir);
    }

    @Listener
    public void onStart(GameStartedServerEvent event) {
        Sponge.getServiceManager().getRegistration(EconomyService.class).ifPresent(prov -> {
            this.economyService = (EconomyService)prov.getProvider();
        });
        ShopConfig.load();
        ShopsData.load();
        CommandSpec shopReport = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_REPORT)).executor((CommandExecutor)new ShopReportExecutor()).arguments(GenericArguments.optional((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))).build();
        CommandSpec shopServerReport = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_SREPORT)).executor((CommandExecutor)new ShopServerReportExecutor()).build();
        CommandSpec shopSpam = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_SPAM)).executor((CommandExecutor)new NoSpamExecutor()).build();
        CommandSpec shopWiki = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_WIKI)).executor((CommandExecutor)new ShopWikiExecutor()).build();
        CommandSpec shopConfigCurrency = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_CONFIG_CURRENCY)).permission("carrotshop.config.currency").executor((CommandExecutor)new ShopConfigCurrencyExecutor()).arguments(GenericArguments.optional((CommandElement)new CurrencyElement((Text)Text.of((String)"currency")))).build();
        CommandSpec shopConfigReload = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_CONFIG_RELOAD)).permission("carrotshop.config.reload").executor((CommandExecutor)new ShopConfigReloadExecutor()).build();
        CommandSpec shopConfig = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_CONFIG)).executor((CommandExecutor)new ShopConfigExecutor()).child((CommandCallable)shopConfigCurrency, new String[]{"currency"}).child((CommandCallable)shopConfigReload, new String[]{"reload"}).build();
        CommandSpec shopImport = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_IMPORT)).permission("carrotshop.import").executor((CommandExecutor)new ShopImportExecutor(this.defaultConfigDir)).arguments(GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"plugin")))).build();
        CommandSpec shopMain = CommandSpec.builder().description((Text)Text.of((String)Lang.HELP_DESC_CMD_MAIN)).executor((CommandExecutor)new ShopMainExecutor()).child((CommandCallable)shopWiki, new String[]{"help", "?", "wiki", "how", "howto", "h"}).child((CommandCallable)shopSpam, new String[]{"hide", "shopchat", "stop", "off", "nospam", "spam", "toggle", "togglechat", "t"}).child((CommandCallable)shopReport, new String[]{"report", "shopreport", "r"}).child((CommandCallable)shopServerReport, new String[]{"serverreport", "server", "servreport", "sr"}).child((CommandCallable)shopConfig, new String[]{"config"}).child((CommandCallable)shopImport, new String[]{"import"}).build();
        Sponge.getCommandManager().register((Object)plugin, (CommandCallable)shopReport, new String[]{"shopreport", "carrotshopreport", "cr", "sr", "carrotreport", "creport", "sreport"});
        Sponge.getCommandManager().register((Object)plugin, (CommandCallable)shopServerReport, new String[]{"serverreport", "carrotshopserverreport", "shopserverreport", "carrotserverreport", "csr", "ssr", "csreport", "ssreport"});
        Sponge.getCommandManager().register((Object)plugin, (CommandCallable)shopSpam, new String[]{"shophide", "hideshopchat", "carrotshophide", "carrothide", "shide", "chide", "sh", "ch"});
        Sponge.getCommandManager().register((Object)plugin, (CommandCallable)shopWiki, new String[]{"shophelp", "carrotshopwiki", "shophelp", "carrotshopwiki", "cshophelp", "cshopwiki", "carrothelp", "carrotwiki", "shelp", "swiki"});
        Sponge.getCommandManager().register((Object)plugin, (CommandCallable)shopMain, new String[]{"shop", "cs", "carrotshop", "s", "c"});
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerClickListener());
        Sponge.getEventManager().registerListeners((Object)this, (Object)new BlockBreakListener());
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerConnexionListener());
    }

    @Listener
    public void onStop(GameStoppingServerEvent event) {
        ShopsData.unload();
    }

    public static CarrotShop getInstance() {
        return plugin;
    }

    public static Logger getLogger() {
        return CarrotShop.getInstance().logger;
    }

    public static EconomyService getEcoService() {
        return CarrotShop.getInstance().economyService;
    }

    public static Cause getCause() {
        return Sponge.getCauseStackManager().getCurrentCause();
    }

    public static boolean noSpam(UUID uuid) {
        return noSpam.contains(uuid);
    }

    public static boolean toggleSpam(UUID uuid) {
        if (noSpam.contains(uuid)) {
            noSpam.remove(uuid);
        } else {
            noSpam.add(uuid);
        }
        return noSpam.contains(uuid);
    }

    static {
        noSpam = new ArrayList<UUID>();
    }
}

