/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.util.LinkedHashSet;
import java.util.Set;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMappingException;
import me.lucko.luckperms.lib.configurate.objectmapping.serialize.AbstractListChildSerializer;
import me.lucko.luckperms.lib.configurate.util.CheckedConsumer;

class SetSerializer
extends AbstractListChildSerializer<Set<?>> {
    SetSerializer() {
    }

    @Override
    TypeToken<?> getElementType(TypeToken<?> containerType) throws ObjectMappingException {
        if (!(containerType.getType() instanceof ParameterizedType)) {
            throw new ObjectMappingException("Raw types are not supported for collections");
        }
        return containerType.resolveType(Set.class.getTypeParameters()[0]);
    }

    @Override
    Set<?> createNew(int length, TypeToken<?> elementType) {
        return new LinkedHashSet(length);
    }

    @Override
    void forEachElement(Set<?> collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    void deserializeSingle(int index, Set<?> collection, Object deserialized) {
        collection.add(deserialized);
    }
}

