/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openmods.calc.CommandSyntaxException;
import openmods.calc.IWhitespaceSplitter;

public class WhitespaceSplitters {
    private static final Pattern SPLITTER_PATTERN = Pattern.compile("\\s*(\\S+)\\s*");

    public static IWhitespaceSplitter fromSplitArray(String ... args) {
        return new ArrayBasedWhitespaceSplitter(args);
    }

    public static IWhitespaceSplitter fromString(String contents) {
        return new StringWhitespaceSplitter(contents);
    }

    private static class StringWhitespaceSplitter
    implements IWhitespaceSplitter {
        private final String contents;
        private final Matcher matcher;
        private boolean matchResult;

        public StringWhitespaceSplitter(String contents) {
            this.contents = contents;
            this.matcher = SPLITTER_PATTERN.matcher(contents);
            this.matchResult = this.matcher.find();
        }

        @Override
        public String getNextPart() {
            if (!this.matchResult) {
                throw new CommandSyntaxException("openmodslib.command.not_enough_arguments", new Object[0]);
            }
            String result = this.matcher.group(1);
            this.matchResult = this.matcher.find();
            return result;
        }

        @Override
        public String getTail() {
            if (!this.matchResult) {
                throw new CommandSyntaxException("openmodslib.command.not_enough_arguments", new Object[0]);
            }
            this.matchResult = false;
            return this.contents.substring(this.matcher.start(1));
        }

        @Override
        public boolean isFinished() {
            return !this.matchResult;
        }
    }

    private static class ArrayBasedWhitespaceSplitter
    implements IWhitespaceSplitter {
        private final Iterator<String> parts;

        public ArrayBasedWhitespaceSplitter(String[] parts) {
            this.parts = Arrays.asList(parts).iterator();
        }

        @Override
        public String getNextPart() {
            if (!this.parts.hasNext()) {
                throw new CommandSyntaxException("openmodslib.command.not_enough_arguments", new Object[0]);
            }
            return this.parts.next();
        }

        @Override
        public String getTail() {
            if (!this.parts.hasNext()) {
                throw new CommandSyntaxException("openmodslib.command.not_enough_arguments", new Object[0]);
            }
            return Joiner.on((String)" ").join(this.parts);
        }

        @Override
        public boolean isFinished() {
            return !this.parts.hasNext();
        }
    }
}

