/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.misc;

import ic2.api.item.ICustomDamageItem;
import ic2.core.inventory.filters.IFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtil {
    public static NBTTagCompound getOrCreateNbtData(ItemStack item) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p();
    }

    public static NBTTagCompound getNbtData(ItemStack item) {
        if (!item.func_77942_o()) {
            return new NBTTagCompound();
        }
        return item.func_77978_p();
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.func_190920_e(newSize);
        return ret;
    }

    public static ItemStack copyWithWildCard(ItemStack itemStack) {
        ItemStack ret = itemStack.func_77946_l();
        ret.func_77964_b(Short.MAX_VALUE);
        return ret;
    }

    public static boolean isStackEqual(ItemStack base, ItemStack toCompare) {
        return StackUtil.isStackEqual(base, toCompare, false, true);
    }

    public static boolean isStackEqual(ItemStack base, ItemStack toCompare, boolean blankValue, boolean ignoreNBT) {
        return StackUtil.isStackEqual(base, toCompare, true, false, blankValue, ignoreNBT);
    }

    public static boolean isStackEqual(ItemStack base, ItemStack toCompare, boolean useMeta, boolean oreDict, boolean blankValue, boolean ignoreNBT) {
        if (base.func_190926_b() || toCompare.func_190926_b()) {
            return false;
        }
        if (base.func_77973_b() != toCompare.func_77973_b()) {
            if (oreDict) {
                return StackUtil.matchOreDicted(base, toCompare);
            }
            return false;
        }
        if (!useMeta) {
            if (!ignoreNBT) {
                if (ItemStack.func_77970_a((ItemStack)base, (ItemStack)toCompare)) {
                    return true;
                }
                if (oreDict) {
                    return StackUtil.matchOreDicted(base, toCompare);
                }
                return false;
            }
            return true;
        }
        if (base.func_77960_j() != toCompare.func_77960_j()) {
            if (!blankValue) {
                if (oreDict) {
                    return StackUtil.matchOreDicted(base, toCompare);
                }
                return false;
            }
            if (ignoreNBT) {
                return base.func_77960_j() == Short.MAX_VALUE;
            }
            if (base.func_77960_j() != Short.MAX_VALUE) {
                if (oreDict) {
                    return StackUtil.matchOreDicted(base, toCompare);
                }
                return false;
            }
        }
        if (!ignoreNBT) {
            if (ItemStack.func_77970_a((ItemStack)base, (ItemStack)toCompare)) {
                return true;
            }
            if (oreDict) {
                return StackUtil.matchOreDicted(base, toCompare);
            }
            return false;
        }
        return true;
    }

    public static boolean matchOreDicted(ItemStack key, ItemStack value) {
        if (key.func_190926_b() || value.func_190926_b()) {
            return false;
        }
        int[] keyList = OreDictionary.getOreIDs((ItemStack)key);
        int[] valueList = OreDictionary.getOreIDs((ItemStack)value);
        for (int keyEntry : keyList) {
            for (int valueEntry : valueList) {
                if (keyEntry != valueEntry) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasOreTag(String oreTag, ItemStack item) {
        if (item.func_190926_b() || item.func_77973_b() == null) {
            return false;
        }
        int oreID = OreDictionary.getOreID((String)oreTag);
        for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
            if (id != oreID) continue;
            return true;
        }
        return false;
    }

    public static ItemStack splitStack(ItemStack input, int size) {
        if (input.func_190926_b()) {
            return null;
        }
        ItemStack copy = input.func_77946_l();
        if (input.func_190916_E() > size) {
            input.func_190918_g(size);
            copy.func_190920_e(size);
            return copy;
        }
        input.func_190920_e(0);
        return copy;
    }

    public static void dropAsEntity(World world, BlockPos pos, List<ItemStack> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            StackUtil.dropAsEntity(world, pos, list.get(i));
        }
    }

    public static void dropAsEntity(World world, BlockPos pos, ItemStack item) {
        if (item.func_190926_b()) {
            return;
        }
        StackUtil.dropAsEntity(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), item);
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack.func_77946_l());
        entityItem.func_174867_a(10);
        world.func_72838_d((Entity)entityItem);
    }

    public static void addToolTip(ItemStack stack, String text) {
        NBTTagCompound nbt = stack.func_190925_c("display");
        NBTTagList list = nbt.func_150295_c("Lore", 8);
        list.func_74742_a((NBTBase)new NBTTagString(TextFormatting.RESET + text + TextFormatting.RESET));
        nbt.func_74782_a("Lore", (NBTBase)list);
    }

    public static ItemStack copyWithDamage(ItemStack item, int newDamage) {
        ItemStack copy = item.func_77946_l();
        if (copy.func_77973_b() instanceof ICustomDamageItem) {
            ((ICustomDamageItem)copy.func_77973_b()).setCustomDamage(copy, newDamage);
        } else {
            copy.func_77964_b(newDamage);
        }
        return copy;
    }

    public static ItemStack copyWithDamageAndSize(ItemStack item, int newDamage, int size) {
        ItemStack copy = item.func_77946_l();
        if (copy.func_77973_b() instanceof ICustomDamageItem) {
            ((ICustomDamageItem)copy.func_77973_b()).setCustomDamage(copy, newDamage);
        } else {
            copy.func_77964_b(newDamage);
        }
        copy.func_190920_e(size);
        return copy;
    }

    public static boolean hasHotbarItem(EntityPlayer player, IFilter filter) {
        if (player == null) {
            return false;
        }
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < 9; ++i) {
            if (!filter.matches(inv.func_70301_a(i))) continue;
            return true;
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (!filter.matches(player.func_184582_a(slot))) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> copyList(List<ItemStack> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            result.add(list.get(i).func_77946_l());
        }
        return result;
    }
}

