/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.filters;

import ic2.api.classic.item.ICropAnalyzer;
import ic2.api.classic.item.IEUReader;
import ic2.api.classic.item.IFoamProvider;
import ic2.api.classic.item.IFuelableItem;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.classic.item.IScannerItem;
import ic2.api.classic.item.IThermometer;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.crops.ICropSeed;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.ICustomDamageItem;
import ic2.api.item.ItemWrapper;
import ic2.core.block.base.util.info.misc.IWrench;
import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.ClassFilter;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.InvertedFilter;
import ic2.core.inventory.filters.ItemFilter;
import ic2.core.item.tool.ItemToolPainter;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class CommonFilters {
    public static IFilter Nothing = new NoneFilter();
    public static IFilter Anything = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b();
        }
    };
    public static IFilter NullBlock = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && Block.func_149634_a((Item)stack.func_77973_b()) == null;
        }
    };
    public static IFilter NoneNullBlock = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a;
        }
    };
    public static IFilter ChargeEU = new EnergyFilter(false, false);
    public static IFilter NotChargeEU = new InvertedFilter(ChargeEU);
    public static IFilter DischargeEU = new EnergyFilter(true, false);
    public static IFilter NotDischargeEU = new InvertedFilter(DischargeEU);
    public static IFilter DischargeEUInternal = new EnergyFilter(true, true);
    public static IFilter NotDischargeEUInternal = new InvertedFilter(DischargeEUInternal);
    public static IFilter DoubleCharge = new DoubleChargeFilter();
    public static IFilter FurnaceFuel = new FuelFilter(true, false);
    public static IFilter NoFurnaceFuel = new InvertedFilter(FurnaceFuel);
    public static IFilter IronFurnaceFuel = new FuelFilter(false, false);
    public static IFilter NoIronFurnaceFuel = new InvertedFilter(IronFurnaceFuel);
    public static IFilter IronFurnaceFuelWithLava = new FuelFilter(false, true);
    public static IFilter NotIronFurnaceFuelWithLava = new InvertedFilter(IronFurnaceFuelWithLava);
    public static IFilter FurnaceInputFilter = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
        }
    };
    public static IFilter ElectricFurnace = new MachineFilter(){

        @Override
        public IMachineRecipeList getList() {
            return ClassicRecipes.furnace;
        }
    };
    public static IFilter Macerator = new MachineFilter(){

        @Override
        public IMachineRecipeList getList() {
            return ClassicRecipes.macerator;
        }
    };
    public static IFilter Extractor = new MachineFilter(){

        @Override
        public IMachineRecipeList getList() {
            return ClassicRecipes.extractor;
        }
    };
    public static IFilter Compressor = new MachineFilter(){

        @Override
        public IMachineRecipeList getList() {
            return ClassicRecipes.compressor;
        }
    };
    public static IFilter Recycler = new MachineFilter(){

        @Override
        public IMachineRecipeList getList() {
            return ClassicRecipes.recycler;
        }
    };
    public static IFilter MassFab = new MachineFilter(){

        @Override
        public IMachineRecipeList getList() {
            return ClassicRecipes.massfabAmplifier;
        }
    };
    public static IFilter uranEnricher = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return TileEntityUraniumEnricher.getTypeFromItem(stack) != 0;
        }
    };
    public static IFilter rareEarth = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return ClassicRecipes.earthExtractor.getEarthValue(stack) > 0.0f;
        }
    };
    public static IFilter ElectrolyzerInput = new ElectrolyzerFilter(true);
    public static IFilter ElectrolyzerOutput = new ElectrolyzerFilter(false);
    public static IFilter[] DyeFilters = CommonFilters.createDyeFilters();
    public static IFilter CannerInput = new ArrayFilter(new ClassFilter(IFuelableItem.class), new ClassFilter(IFoamProvider.class), new BasicItemFilter(Ic2Items.tinCan.func_77946_l()), new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (ClassicRecipes.canningMachine.hasCanningContainer(stack)) {
                return true;
            }
            Item item = stack.func_77973_b();
            if (item instanceof ICustomDamageItem) {
                return ClassicRecipes.canningMachine.getRepairMap().containsKey((ICustomDamageItem)item);
            }
            return false;
        }
    });
    public static IFilter SeedFilter = new ClassFilter(ICropSeed.class);
    public static IFilter SeedFilterScanned = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof ICropSeed)) {
                return false;
            }
            return ((ICropSeed)stack.func_77973_b()).getScannedFromStack(stack) >= 4;
        }
    };
    public static IFilter Fertilizer = new BasicItemFilter(Ic2Items.fertilizer.func_77946_l());
    public static IFilter Hydration = new ItemFilter(Ic2Items.hydrationCell.func_77946_l());
    public static IFilter WeedEx = new ItemFilter(Ic2Items.weedEx.func_77946_l());
    public static IFilter FluidFilter = new ContainerFilter();
    public static IFilter EmptyCell = new BasicItemFilter(Ic2Items.emptyCell.func_77946_l());
    public static IFilter Scanners = new ClassFilter(IScannerItem.class);
    public static IFilter MiningDrills = new ClassFilter(IMiningDrill.class);
    public static IFilter bookEnchanting = new ArrayFilter(new ItemFilter(Items.field_151122_aG), new ItemFilter(Items.field_151134_bR));
    public static IFilter lapisFilter = new BasicItemFilter(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
    public static IFilter uranFilter = new BasicItemFilter(Ic2Items.uraniumIngot.func_77946_l());
    public static IFilter cargePadFitler = new NuclearFilter();
    public static IFilter toolBoxFilter = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && ItemWrapper.canBeStoredInToolbox(stack);
        }
    };
    public static IFilter upgradeContainerFilter = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.upgradeContainer)) {
                return false;
            }
            return stack.func_77973_b() instanceof IMachineUpgradeItem;
        }
    };
    public static IFilter uuMatter = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return StackUtil.isStackEqual(stack, Ic2Items.uuMatter);
        }
    };
    public static IFilter fuelableItem = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof IFuelableItem)) {
                return false;
            }
            return ((IFuelableItem)stack.func_77973_b()).hasFuel(stack);
        }
    };
    public static IFilter euReaderActive = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof IEUReader)) {
                return false;
            }
            return ((IEUReader)stack.func_77973_b()).isEUReader(stack);
        }
    };
    public static IFilter cropAnalyzerActive = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof ICropAnalyzer)) {
                return false;
            }
            return ((ICropAnalyzer)stack.func_77973_b()).isCropAnalyzer(stack);
        }
    };
    public static IFilter thermometerActive = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof IThermometer)) {
                return false;
            }
            return ((IThermometer)stack.func_77973_b()).isThermometer(stack);
        }
    };
    public static IFilter wrenchActive = new IFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof IWrench)) {
                return false;
            }
            return ((IWrench)stack.func_77973_b()).isWrench(stack);
        }
    };

    static IFilter[] createDyeFilters() {
        EnumDyeColor[] colors = EnumDyeColor.values();
        IFilter[] filters = new IFilter[colors.length];
        for (EnumDyeColor color : colors) {
            filters[color.func_176767_b()] = new DyeFilter(color);
        }
        return filters;
    }

    public static class NuclearFilter
    implements IFilter {
        @Override
        public boolean matches(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            int drained = (int)ElectricItem.manager.discharge(stack, 1.0, 3, true, false, true);
            if (drained > 0) {
                return true;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.reactorUraniumRodSingle)) {
                return true;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.reactorUraniumRodDual)) {
                return true;
            }
            return StackUtil.isStackEqual(stack, Ic2Items.reactorUraniumRodQuad);
        }
    }

    public static class DoubleChargeFilter
    implements IFilter {
        @Override
        public boolean matches(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            return ElectricItem.manager.charge(stack, 1.0, Integer.MAX_VALUE, false, true) > 0.0 || ElectricItem.manager.discharge(stack, 1.0, Integer.MAX_VALUE, true, false, true) > 0.0;
        }
    }

    public static class ContainerFilter
    implements IFilter {
        @Override
        public boolean matches(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
    }

    public static class DyeFilter
    implements IFilter {
        EnumDyeColor color;
        List<ItemStack> dyes;

        public DyeFilter(EnumDyeColor dye) {
            this.color = dye;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (this.dyes == null) {
                this.dyes = ItemToolPainter.colorToItems.get(this.color.func_176767_b());
                if (this.dyes == null) {
                    this.dyes = new ArrayList<ItemStack>();
                }
            }
            if (this.dyes.isEmpty() || stack.func_190926_b()) {
                return false;
            }
            for (ItemStack item : this.dyes) {
                if (!StackUtil.isStackEqual(item, stack)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ElectrolyzerFilter
    implements IFilter {
        boolean input;

        public ElectrolyzerFilter(boolean in) {
            this.input = in;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return ClassicRecipes.electrolyzer.getOutput(stack, this.input) != null;
        }
    }

    static abstract class MachineFilter
    implements IFilter {
        MachineFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            return this.getList().getRecipeInAndOutput(stack, true) != null;
        }

        public abstract IMachineRecipeList getList();
    }

    public static class FuelFilter
    implements IFilter {
        boolean furnace;
        boolean lava;

        public FuelFilter(boolean isVanila, boolean allowLava) {
            this.furnace = isVanila;
            this.lava = allowLava;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return this.furnace ? TileEntityFurnace.func_145954_b((ItemStack)stack) : Info.itemInfo.getFuelValue(stack, this.lava) > 0;
        }
    }

    public static class EnergyFilter
    implements IFilter {
        boolean discharge;
        boolean internal;

        public EnergyFilter(boolean dis, boolean intern) {
            this.discharge = dis;
            this.internal = intern;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (this.discharge) {
                return ElectricItem.manager.discharge(stack, 1.0, Integer.MAX_VALUE, false, this.internal, true) > 0.0;
            }
            return ElectricItem.manager.charge(stack, 1.0, Integer.MAX_VALUE, false, true) > 0.0;
        }
    }

    public static class NoneFilter
    implements IFilter {
        @Override
        public boolean matches(ItemStack stack) {
            return false;
        }
    }
}

