/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.cables.types;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.core.block.wiring.cables.types.CableBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.item.ItemStack;

public class BronzeCable
extends CableBase {
    @Override
    public int getMaxInsulationTypes() {
        return 2;
    }

    @Override
    public double getConductorLoss(int insulation) {
        switch (insulation) {
            case 0: {
                return 0.7f;
            }
            case 1: {
                return 0.65f;
            }
            case 2: {
                return 0.6f;
            }
        }
        return 0.0;
    }

    @Override
    public double getInsulationEnergyAbsorption(int insulation) {
        switch (insulation) {
            case 0: {
                return 8.0;
            }
            case 1: {
                return 32.0;
            }
            case 2: {
                return 128.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getInsulationBreakdownEnergy(int insulation) {
        return 9001.0;
    }

    @Override
    public double getConductorBreakdownEnergy(int insulation) {
        return 129.0;
    }

    @Override
    public double getConductorThickness(int insulation) {
        switch (insulation) {
            case 0: {
                return 4.0;
            }
            case 1: {
                return 6.0;
            }
            case 2: {
                return 7.0;
            }
        }
        return 0.0;
    }

    @Override
    public int getTexture(int insulation, IEnergyConductorColored.WireColor color, boolean active) {
        switch (insulation) {
            case 0: {
                return 221 + color.ordinal();
            }
            case 1: {
                return 238 + color.ordinal();
            }
            case 2: {
                return 255 + color.ordinal();
            }
        }
        return 187;
    }

    @Override
    public int getItemIcon(int insulation) {
        return 109 + insulation;
    }

    @Override
    public LocaleComp getName(int insulation) {
        switch (insulation) {
            case 0: {
                return Ic2ItemLang.bronzeCable;
            }
            case 1: {
                return Ic2ItemLang.bronzeCableInsulated;
            }
            case 2: {
                return Ic2ItemLang.bronzeCableDoubleInsulated;
            }
        }
        return super.getName(insulation);
    }

    @Override
    public ItemStack getDrops(int insulation) {
        switch (insulation) {
            case 1: {
                return Ic2Items.insulatedBronzeCable.func_77946_l();
            }
            case 2: {
                return Ic2Items.doubleInsulatedBronzeCable.func_77946_l();
            }
        }
        return Ic2Items.bronzeCable.func_77946_l();
    }

    @Override
    public boolean canProvideRedstone() {
        return false;
    }
}

