/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.crops;

import com.google.common.base.Objects;
import ic2.api.crops.CropCard;
import net.minecraft.nbt.NBTTagCompound;

public class SeedEntry {
    private final byte growth;
    private final byte gain;
    private final byte resistance;
    private int amount;
    private final int hashCode;

    protected SeedEntry() {
        this.hashCode = 0;
        this.growth = 0;
        this.gain = 0;
        this.resistance = 0;
    }

    public SeedEntry(NBTTagCompound nbt) {
        this(nbt.func_74771_c("Growth"), nbt.func_74771_c("Gain"), nbt.func_74771_c("Resistance"));
        this.amount = nbt.func_74762_e("SeedAmount");
    }

    public SeedEntry(int par1, int par2, int par3, int par4) {
        this((byte)par1, (byte)par2, (byte)par3);
        this.amount = par4;
    }

    public SeedEntry(byte par1, byte par2, byte par3) {
        this.growth = par1;
        this.gain = par2;
        this.resistance = par3;
        this.amount = 1;
        this.hashCode = Objects.hashCode((Object[])new Object[]{this.growth, this.gain, this.resistance});
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("Growth", this.growth);
        nbt.func_74774_a("Gain", this.gain);
        nbt.func_74774_a("Resistance", this.resistance);
        nbt.func_74768_a("SeedAmount", this.amount);
        return nbt;
    }

    public void combine(SeedEntry entry) {
        this.amount += entry.amount;
    }

    public int consume(int requested, boolean doDrain) {
        if (this.amount < requested) {
            requested = this.amount;
        }
        if (doDrain) {
            this.amount -= requested;
        }
        return requested;
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public byte getGain() {
        return this.gain;
    }

    public byte getGrowth() {
        return this.growth;
    }

    public byte getResistance() {
        return this.resistance;
    }

    public int getAmount() {
        return this.amount;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public CropCard getCard(CropCard card) {
        return card;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SeedEntry) {
            SeedEntry entry = (SeedEntry)obj;
            if (entry.growth == this.growth && entry.gain == this.gain && entry.resistance == this.resistance) {
                return true;
            }
        }
        return false;
    }
}

