/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropArgentum
extends CropCardBase {
    public CropArgentum() {
        super(new CropProperties(8, 2, 0, 0, 2, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 4) {
            return this.getSprite("bc")[85];
        }
        return this.getSprite("bc")[31 + state];
    }

    @Override
    public String getDiscoveredBy() {
        return "Speiger";
    }

    @Override
    public String getId() {
        return "Argentum";
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return Ic2Items.silverDust.func_77946_l();
    }

    @Override
    public double dropGainChance() {
        return super.dropGainChance() / 2.0;
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Silver", "Leaves", "Metal"};
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 2200;
        }
        return 1000;
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3 || cropTile.getCurrentSize() == 3 && (cropTile.isBlockBelow("oreSilver") || cropTile.isBlockBelow("blockSilver"));
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }
}

