/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.content.matrix.MatrixCache;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.util.StackUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MatrixUpdateProtocol
extends UpdateProtocol<SynchronizedMatrixData> {
    public MatrixUpdateProtocol(TileEntityInductionCasing tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        IBlockState state = this.pointer.func_145831_w().func_180495_p(new BlockPos(x, y, z));
        return state.func_177230_c() == MekanismBlocks.BasicBlock2 && state.func_177230_c().func_176201_c(state) == 1;
    }

    @Override
    public boolean isValidInnerNode(int x, int y, int z) {
        if (super.isValidInnerNode(x, y, z)) {
            return true;
        }
        TileEntity tile = new Coord4D(x, y, z, this.pointer.func_145831_w().field_73011_w.getDimension()).getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        return tile instanceof TileEntityInductionCell || tile instanceof TileEntityInductionProvider;
    }

    protected MatrixCache getNewCache() {
        return new MatrixCache();
    }

    @Override
    protected SynchronizedMatrixData getNewStructure() {
        return new SynchronizedMatrixData();
    }

    @Override
    protected MultiblockManager<SynchronizedMatrixData> getManager() {
        return Mekanism.matrixManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedMatrixData> cache, MultiblockCache<SynchronizedMatrixData> merge) {
        MatrixCache matrixCache = (MatrixCache)cache;
        MatrixCache mergeCache = (MatrixCache)merge;
        List<ItemStack> rejects = StackUtils.getMergeRejects(matrixCache.inventory, mergeCache.inventory);
        if (!rejects.isEmpty()) {
            rejectedItems.addAll(rejects);
        }
        StackUtils.merge(matrixCache.inventory, mergeCache.inventory);
    }

    @Override
    protected void onStructureDestroyed(SynchronizedMatrixData structure) {
        structure.tick(this.pointer.func_145831_w());
        super.onStructureDestroyed(structure);
    }

    @Override
    protected boolean canForm(SynchronizedMatrixData structure) {
        for (Coord4D coord : this.innerNodes) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (tile instanceof TileEntityInductionCell) {
                structure.addCell(coord, (TileEntityInductionCell)tile);
                continue;
            }
            if (!(tile instanceof TileEntityInductionProvider)) continue;
            structure.addProvider(coord, (TileEntityInductionProvider)tile);
        }
        return true;
    }
}

