/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import trinsdar.ic2c_extras.container.ContainerElectricDisenchanter;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;

public class TileEntityElectricDisenchanter
extends TileEntityElecMachine
implements IHasGui,
ITickable,
IProgressMachine {
    private static final int SLOT_BOOK = 0;
    private static final int SLOT_TOOL = 1;
    private static final int SLOT_OUTPUT = 2;
    private static final int SLOT_FUEL = 3;
    int progress = 0;
    int maxProgress = 100;
    boolean canProgress = false;

    public TileEntityElectricDisenchanter() {
        super(4, 512);
        this.setMaxEnergy(10000000);
        this.setFuelSlot(3);
        this.addGuiFields(new String[]{"progress"});
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{3});
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{0, 1});
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{2});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{2});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{0, 1});
        handler.registerInputFilter((IFilter)new ArrayFilter(new IFilter[]{CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)}), new int[]{1});
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, new int[]{3});
        handler.registerSlotType(SlotType.Fuel, new int[]{3});
        handler.registerSlotType(SlotType.Input, new int[]{0, 1});
        handler.registerSlotType(SlotType.Output, new int[]{2});
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.ELECTRIC_DISENCHANTER;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        NBTTagList enchantList;
        ItemStack tool;
        NBTTagCompound nbt;
        super.setStackInSlot(slot, stack);
        this.canProgress = false;
        if (!this.getStackInSlot(0).func_190926_b() && !this.getStackInSlot(1).func_190926_b() && this.getStackInSlot(2).func_190926_b() && (nbt = StackUtil.getOrCreateNbtData((ItemStack)(tool = this.getStackInSlot(1)))).func_74764_b("ench") && !(enchantList = nbt.func_150295_c("ench", 10)).func_82582_d()) {
            this.canProgress = true;
        }
    }

    public boolean supportsNotify() {
        return false;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerElectricDisenchanter(player.field_71071_by, this);
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer entityPlayer) {
        return GuiComponentContainer.class;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return !this.func_145837_r();
    }

    public boolean hasGui(EntityPlayer entityPlayer) {
        return true;
    }

    public float getProgress() {
        return this.progress;
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void func_73660_a() {
        this.handleChargeSlot(this.maxEnergy);
        if (this.canProgress && this.getStoredEU() >= 500) {
            this.setActive(true);
            ++this.progress;
            this.useEnergy(500);
            if (this.progress >= this.maxProgress) {
                this.disEnchant();
                this.progress = 0;
                this.notifyNeighbors();
            }
            this.getNetwork().updateTileGuiField((TileEntity)this, "progress");
        } else {
            if (this.progress != 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField((TileEntity)this, "progress");
            }
            this.setActive(false);
        }
    }

    public void disEnchant() {
        ItemStack tool = this.getStackInSlot(1);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)tool);
        NBTTagList enchantList = nbt.func_150295_c("ench", 10);
        int index = this.field_145850_b.field_73012_v.nextInt(enchantList.func_74745_c());
        NBTTagCompound enchantment = enchantList.func_150305_b(index);
        ItemStack output = new ItemStack(Items.field_151134_bR);
        NBTTagCompound outputNBT = StackUtil.getOrCreateNbtData((ItemStack)output);
        NBTTagList outputEnchantList = new NBTTagList();
        outputEnchantList.func_74742_a((NBTBase)enchantment);
        outputNBT.func_74782_a("StoredEnchantments", (NBTBase)outputEnchantList);
        enchantList.func_74744_a(index);
        if (enchantList.func_82582_d()) {
            nbt.func_82580_o("ench");
            if (nbt.func_74764_b("RepairCost")) {
                nbt.func_74768_a("RepairCost", 0);
            }
        }
        this.getStackInSlot(0).func_190918_g(1);
        this.setStackInSlot(2, output);
    }
}

