/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.recipes;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.item.recipe.entry.RecipeInputCombined;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.item.recipe.upgrades.FlagModifier;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Loader;
import trinsdar.ic2c_extras.Ic2cExtrasConfig;
import trinsdar.ic2c_extras.recipes.Ic2cExtrasRecipes;
import trinsdar.ic2c_extras.util.Registry;

public class CraftingRecipes {
    static IRecipeInput casing = new RecipeInputCombined(1, new IRecipeInput[]{new RecipeInputOreDict("casingRefinedIron"), new RecipeInputOreDict("casingBronze"), new RecipeInputOreDict("casingSteel")});
    static IRecipeInput crushedCopper = new RecipeInputCombined(1, new IRecipeInput[]{new RecipeInputOreDict("crushedCopper"), new RecipeInputOreDict("crushedPurifiedCopper")});
    static IRecipeInput crushedTin = new RecipeInputCombined(1, new IRecipeInput[]{new RecipeInputOreDict("crushedTin"), new RecipeInputOreDict("crushedPurifiedTin")});
    static ICraftingRecipeList recipes = ClassicRecipes.advCrafting;
    static final String MACHINE_BASIC = "machineBlockBasic";
    static final String MACHINE_ADV = "machineBlockAdvanced";

    static ICraftingRecipeList.IRecipeModifier cell() {
        return new ICraftingRecipeList.IRecipeModifier(){

            public void clear() {
            }

            public boolean isStackValid(ItemStack itemStack) {
                FluidStack fluid = FluidUtil.getFluidContained((ItemStack)itemStack);
                return fluid == null && itemStack.func_77973_b() == Registry.universalFluidCell;
            }

            public ItemStack getOutput(ItemStack itemStack, boolean b) {
                return itemStack;
            }

            public boolean isOutput(ItemStack itemStack) {
                return false;
            }
        };
    }

    public static void init() {
        CraftingRecipes.initShapedRecipes();
        CraftingRecipes.initShapelessRecipes();
        CraftingRecipes.initReplaceRecipes();
        CraftingRecipes.initCompressRecipes();
        CraftingRecipes.removeIc2Recipes();
    }

    public static void initShapedRecipes() {
        FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
        recipes.addRecipe(new ItemStack((Block)Registry.advancedSteamTurbine, 1), new Object[]{" S ", "STS", " S ", Character.valueOf('S'), Ic2Items.basicTurbine, Character.valueOf('T'), Ic2Items.transformerMV});
        String basicCircuit = "circuitBasic";
        recipes.addRecipe(new ItemStack((Block)Registry.oreWashingPlant, 1), new Object[]{"III", "BCB", "McM", Character.valueOf('I'), IC2.getRefinedIron(), Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('C'), MACHINE_BASIC, Character.valueOf('M'), Ic2Items.carbonMesh, Character.valueOf('c'), basicCircuit});
        recipes.addRecipe(new ItemStack((Block)Registry.thermalWasher, 1), new Object[]{"BBB", "BOB", "BAB", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('O'), Registry.oreWashingPlant, Character.valueOf('A'), MACHINE_ADV});
        recipes.addRecipe(new ItemStack((Block)Registry.thermalCentrifuge, 1), new Object[]{"CMC", "IAI", "IHI", Character.valueOf('C'), Registry.coil, Character.valueOf('M'), Ic2Items.miningLaser, Character.valueOf('I'), IC2.getRefinedIron(), Character.valueOf('A'), MACHINE_ADV, Character.valueOf('H'), Registry.heatConductor});
        recipes.addRecipe(new ItemStack((Block)Registry.fluidCanningMachine), new Object[]{" C ", "EcE", "ITI", Character.valueOf('C'), Ic2Items.electricCircuit, Character.valueOf('E'), Ic2Items.emptyCell, Character.valueOf('c'), Ic2Items.canner, Character.valueOf('T'), Ic2Items.machineTank, Character.valueOf('I'), "ingotTin"});
        if (!Loader.isModLoaded((String)"gtc_expansion") || !Ic2cExtrasConfig.compatGTCX) {
            recipes.addRecipe(new ItemStack((Block)Registry.roller, 1), new Object[]{"CPC", "PBP", "cPc", Character.valueOf('C'), basicCircuit, Character.valueOf('B'), MACHINE_BASIC, Character.valueOf('c'), Registry.coil, Character.valueOf('P'), Blocks.field_150331_J});
            recipes.addRecipe(new ItemStack((Block)Registry.extruder, 1), new Object[]{"iCi", "cMc", "iCi", Character.valueOf('C'), basicCircuit, Character.valueOf('i'), casing, Character.valueOf('M'), MACHINE_BASIC, Character.valueOf('c'), Registry.coil});
            recipes.addRecipe(new ItemStack((Block)Registry.impellerizedRoller, 1), new Object[]{"CCC", "CRC", "CBC", Character.valueOf('R'), Registry.roller, Character.valueOf('B'), MACHINE_ADV, Character.valueOf('C'), Blocks.field_150320_F});
            recipes.addRecipe(new ItemStack((Block)Registry.liquescentExtruder, 1), new Object[]{"CCC", "CEC", "CBC", Character.valueOf('E'), Registry.extruder, Character.valueOf('B'), MACHINE_ADV, Character.valueOf('C'), casing});
            recipes.addRecipe(new ItemStack((Block)Registry.metalBender), new Object[]{" c ", "RAE", "rcr", Character.valueOf('c'), "circuitAdvanced", Character.valueOf('R'), Registry.impellerizedRoller, Character.valueOf('A'), MACHINE_ADV, Character.valueOf('E'), Registry.liquescentExtruder, Character.valueOf('r'), Ic2cExtrasRecipes.getRefinedIronCasing()});
        }
        if (!Loader.isModLoaded((String)"gtclassic")) {
            recipes.addRecipe(new ItemStack((Block)Registry.autocraftingTable), new Object[]{" B ", "CcC", " A ", Character.valueOf('B'), Ic2Items.battery, Character.valueOf('C'), "circuitAdvanced", Character.valueOf('c'), "workbench", Character.valueOf('A'), MACHINE_ADV});
        }
        recipes.addRecipe(new ItemStack((Block)Registry.electricHeatGenerator), new Object[]{"CBC", "CcC", "CHC", Character.valueOf('C'), "casing" + IC2.getRefinedIron().substring(5), Character.valueOf('B'), Ic2Items.battery, Character.valueOf('c'), "circuitAdvanced", Character.valueOf('H'), Registry.heatConductor});
        recipes.addRecipe(new ItemStack((Block)Registry.fermenter), new Object[]{"CCC", "ccc", "CHC", Character.valueOf('C'), "casing" + IC2.getRefinedIron().substring(5), Character.valueOf('c'), Ic2Items.emptyCell, Character.valueOf('H'), Registry.heatConductor});
        recipes.addRecipe(new ItemStack((Block)Registry.treeTapper), new Object[]{"CTC", "HcH", "MAM", Character.valueOf('C'), "circuitBasic", Character.valueOf('T'), Ic2Items.electricTreeTap, Character.valueOf('H'), new ItemStack((Block)Blocks.field_150438_bZ, 2), Character.valueOf('c'), "chestWood", Character.valueOf('M'), StackUtil.copyWithSize((ItemStack)Ic2Items.miningPipe, (int)8), Character.valueOf('A'), MACHINE_ADV});
        recipes.addRecipe(new ItemStack((Block)Registry.electricDisenchanter), new Object[]{"EeE", "ebe", "BBB", Character.valueOf('E'), Items.field_151166_bC, Character.valueOf('e'), new ItemStack(Items.field_151134_bR, 1, Short.MAX_VALUE), Character.valueOf('b'), Ic2Items.electricEnchanter, Character.valueOf('B'), Blocks.field_150342_X});
        recipes.addRecipe(new ItemStack((Block)Registry.reinforcedEncasedCable), new Object[]{"RRR", "RCR", "RRR", Character.valueOf('R'), Ic2Items.reinforcedStone, Character.valueOf('C'), Ic2Items.tribbleInsulatedIronCable});
        recipes.addRecipe(new ItemStack((Item)Registry.coil, 1), new Object[]{"CCC", "CIC", "CCC", Character.valueOf('I'), IC2.getRefinedIron(), Character.valueOf('C'), Ic2Items.copperCable});
        recipes.addRecipe(new ItemStack((Item)Registry.heatConductor, 1), new Object[]{"RRB", "RBR", "BRR", Character.valueOf('R'), "itemRubber", Character.valueOf('B'), "ingotCopper"});
        recipes.addShapelessRecipe(new ItemStack((Item)Registry.universalFluidCell), new Object[]{Ic2Items.emptyCell.func_77946_l()});
        recipes.addShapelessRecipe(Ic2Items.emptyCell.func_77946_l(), new Object[]{CraftingRecipes.cell(), new ItemStack((Item)Registry.universalFluidCell)});
        recipes.addRecipe(new ItemStack((Item)Registry.blankPress), new Object[]{"H", "P", "P", Character.valueOf('H'), "craftingToolForgeHammer", Character.valueOf('P'), "plateRefinedIron"});
        recipes.addRecipe(new ItemStack((Item)Registry.rollingPress), new Object[]{"H", "P", Character.valueOf('H'), "craftingToolForgeHammer", Character.valueOf('P'), Registry.blankPress});
        recipes.addRecipe(new ItemStack((Item)Registry.extrudingPress), new Object[]{"CP", Character.valueOf('C'), "craftingToolWireCutter", Character.valueOf('P'), Registry.blankPress});
        recipes.addRecipe(new ItemStack((Item)Registry.cuttingPress), new Object[]{"P ", " C", Character.valueOf('P'), Registry.blankPress, Character.valueOf('C'), "craftingToolWireCutter"});
        recipes.addRecipe(new ItemStack((Item)Registry.lathingPress), new Object[]{" P", "C ", Character.valueOf('P'), Registry.blankPress, Character.valueOf('C'), "craftingToolWireCutter"});
        recipes.addRecipe(new ItemStack((Item)Registry.gearingPress), new Object[]{"C", "P", Character.valueOf('C'), "craftingToolWireCutter", Character.valueOf('P'), Registry.blankPress});
        recipes.addRecipe(new ItemStack((Item)Registry.craftingHammer, 1), new Object[]{"III", "III", " S ", Character.valueOf('I'), "ingotRefinedIron", Character.valueOf('S'), "stickWood"});
        recipes.addRecipe(new ItemStack((Item)Registry.wireCutters, 1), new Object[]{"I I", " I ", "S S", Character.valueOf('I'), "ingotRefinedIron", Character.valueOf('S'), "stickWood"});
        recipes.addRecipe(Ic2Items.fuelCan, new Object[]{" TT", "T T", "TTT", Character.valueOf('T'), "casingTin"});
        recipes.addRecipe(new ItemStack((Block)Registry.stoneDustBlock), new Object[]{"SS", "SS", Character.valueOf('S'), "dustStone"});
        recipes.addRecipe(Ic2Items.reactorCoolantCellSimple, new Object[]{" T ", "TWT", " T ", Character.valueOf('T'), "casingTin", Character.valueOf('W'), water});
        recipes.addRecipe(Ic2Items.reactorCoolantCellTriple, new Object[]{"TTT", "CCC", "TTT", Character.valueOf('T'), "casingTin", Character.valueOf('C'), Ic2Items.reactorCoolantCellSimple});
        recipes.addRecipe(Ic2Items.reactorCoolantCellTriple, new Object[]{"TTT", "WWW", "TTT", Character.valueOf('T'), new RecipeInputOreDict("casingTin", 2), Character.valueOf('W'), StackUtil.copyWithSize((ItemStack)Ic2Items.waterCell, (int)2)});
        recipes.addRecipe(Ic2Items.reactorCoolantCellSix, new Object[]{"TCT", "TDT", "TCT", Character.valueOf('T'), "casingTin", Character.valueOf('C'), Ic2Items.reactorCoolantCellTriple, Character.valueOf('D'), Ic2Items.denseCopperPlate});
        recipes.addRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.emptyCell, (int)16), new Object[]{" T ", "T T", " T ", Character.valueOf('T'), "casingTin"});
        recipes.addRecipe(new ItemStack((Item)Registry.energiumDust, 9), new Object[]{"RRR", "RDR", "RRR", Character.valueOf('R'), new RecipeInputOreDict("dustRedstone", 2), Character.valueOf('D'), "dustDiamond"});
        recipes.addShapelessRecipe(Ic2Items.nanoHelmet.func_77946_l(), new Object[]{new FlagModifier(Ic2Items.nanoHelmet.func_77946_l(), "ReactorPlating", true).setUsesInput(), Ic2Items.nanoHelmet.func_77946_l(), Ic2Items.reactorPlating.func_77946_l()});
        recipes.addShapelessRecipe(Ic2Items.nanoChest.func_77946_l(), new Object[]{new FlagModifier(Ic2Items.nanoChest.func_77946_l(), "ReactorPlating", true).setUsesInput(), Ic2Items.nanoChest.func_77946_l(), Ic2Items.reactorPlating.func_77946_l()});
        recipes.addShapelessRecipe(Ic2Items.nanoLeggings.func_77946_l(), new Object[]{new FlagModifier(Ic2Items.nanoLeggings.func_77946_l(), "ReactorPlating", true).setUsesInput(), Ic2Items.nanoLeggings.func_77946_l(), Ic2Items.reactorPlating.func_77946_l()});
        recipes.addShapelessRecipe(Ic2Items.nanoBoots.func_77946_l(), new Object[]{new FlagModifier(Ic2Items.nanoBoots.func_77946_l(), "ReactorPlating", true).setUsesInput(), Ic2Items.nanoBoots.func_77946_l(), Ic2Items.reactorPlating.func_77946_l()});
        if (Ic2cExtrasConfig.requiredLeadUses) {
            recipes.overrideRecipe("shaped_tile.blockreactorchamber_1490756150", Ic2Items.reactorChamber.func_77946_l(), new Object[]{" L ", "LML", " L ", Character.valueOf('L'), "plateDenseLead", Character.valueOf('M'), MACHINE_BASIC});
            recipes.overrideRecipe("shaped_tile.blocknuclearreactor_1318009097", Ic2Items.nuclearReactor.func_77946_l(), new Object[]{"LCL", "RRR", "LGL", Character.valueOf('L'), "plateDenseLead", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('R'), Ic2Items.reactorChamber, Character.valueOf('G'), Ic2Items.generator});
            if (!Loader.isModLoaded((String)"gtc_expansion") || !Ic2cExtrasConfig.compatGTCX) {
                recipes.overrideShapelessRecipe("shapeless_item.itemreactorplating_1093967048", Ic2Items.reactorPlating, new Object[]{"ingotLead", Ic2Items.advancedAlloy});
            }
        } else {
            recipes.addRecipe(Ic2Items.reactorChamber.func_77946_l(), new Object[]{" L ", "LML", " L ", Character.valueOf('L'), "plateDenseLead", Character.valueOf('M'), MACHINE_BASIC});
            if (!Loader.isModLoaded((String)"gtc_expansion") || !Ic2cExtrasConfig.compatGTCX) {
                recipes.addShapelessRecipe(Ic2Items.reactorPlating, new Object[]{"ingotLead", Ic2Items.advancedAlloy});
            }
        }
        recipes.addRecipe(new ItemStack((Item)Registry.containmentBox), new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), "casingLead", Character.valueOf('C'), "chest"});
        if (Loader.isModLoaded((String)"gtclassic")) {
            recipes.addRecipe(Ic2Items.battery, new Object[]{" C ", "TRT", "TRT", Character.valueOf('C'), Ic2Items.copperCable, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), "casingTin"});
        } else {
            recipes.addRecipe(Ic2Items.battery, new Object[]{" C ", "TRT", "TRT", Character.valueOf('C'), Ic2Items.insulatedCopperCable, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), "casingTin"});
        }
    }

    public static void removeIc2Recipes() {
        if (Ic2cExtrasConfig.removeLossyWrenchMechanic) {
            Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.precisionwrench_-1943783685");
            Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.precisionwrench_-1322002202");
        }
    }

    public static void initReplaceRecipes() {
        if (!IC2.config.getFlag("SteelRecipes") && Ic2cExtrasConfig.cablesTakeSteel) {
            if (!Ic2cExtrasConfig.plateCablesOverrideRegularCables) {
                recipes.overrideRecipe("shaped_item.itemironcable_1314416875", StackUtil.copyWithSize((ItemStack)Ic2Items.ironCable, (int)12), new Object[]{"III", Character.valueOf('I'), "ingotSteel"});
            }
            recipes.overrideRecipe("shaped_item.itemironcablei_926773675", StackUtil.copyWithSize((ItemStack)Ic2Items.insulatedIronCable, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), "itemRubber", Character.valueOf('I'), "ingotSteel"});
            recipes.overrideRecipe("shaped_item.itemironcableii_268464298", StackUtil.copyWithSize((ItemStack)Ic2Items.doubleInsulatedIronCable, (int)4), new Object[]{"RRR", "RIR", "RRR", Character.valueOf('R'), "itemRubber", Character.valueOf('I'), "ingotSteel"});
            recipes.overrideRecipe("shaped_item.itemplasmacable_-449044295", StackUtil.copyWithSize((ItemStack)Ic2Items.plasmaCable, (int)4), new Object[]{"CCC", "IPI", "CCC", Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('I'), "ingotSteel", Character.valueOf('P'), Ic2Items.plasmaCore});
        }
        if (Ic2cExtrasConfig.emptyNuclearRod) {
            ItemStack emptyFuelRod = new ItemStack((Item)Registry.emptyFuelRod);
            recipes.overrideShapelessRecipe("shapeless_item.reactoruraniumsimple_-1804731375", Ic2Items.reactorUraniumRodSingle, new Object[]{emptyFuelRod, Ic2Items.uraniumIngot});
            ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.uraniumIngot);
            ClassicRecipes.canningMachine.registerCannerItem(emptyFuelRod, (IRecipeInput)new RecipeInputItemStack(Ic2Items.uraniumIngot), Ic2Items.reactorUraniumRodSingle);
            if (!IC2.config.getFlag("HardEnrichedUran")) {
                recipes.overrideShapelessRecipe("shapeless_item.reactoruraniumredstonesimple_-1804729360", Ic2Items.reactorRedstoneUraniumRodSingle, new Object[]{emptyFuelRod, Ic2Items.redstoneUraniumIngot});
                recipes.overrideShapelessRecipe("shapeless_item.reactoruraniumblazesimple_-1804728306", Ic2Items.reactorBlazeUraniumRodSingle, new Object[]{emptyFuelRod, Ic2Items.blazeUraniumIngot});
                recipes.overrideShapelessRecipe("shapeless_item.reactoruraniumenderpearlsimple_-1804727252", Ic2Items.reactorEnderPearlUraniumRodSingle, new Object[]{emptyFuelRod, Ic2Items.enderPearlUraniumIngot});
                recipes.overrideShapelessRecipe("shapeless_item.reactoruraniumnetherstarsimple_-1804726198", Ic2Items.reactorNetherStarUraniumRodSingle, new Object[]{emptyFuelRod, Ic2Items.netherStarUraniumIngot});
                recipes.overrideShapelessRecipe("shapeless_item.reactoruraniumcharcoalsimple_-1804725144", Ic2Items.reactorCharcoalUraniumRodSingle, new Object[]{emptyFuelRod, Ic2Items.charcoalUraniumIngot});
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.redstoneUraniumIngot);
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.blazeUraniumIngot);
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.enderPearlUraniumIngot);
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.netherStarUraniumIngot);
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.charcoalUraniumIngot);
                ClassicRecipes.canningMachine.registerCannerItem(emptyFuelRod, (IRecipeInput)new RecipeInputItemStack(Ic2Items.redstoneUraniumIngot), Ic2Items.reactorRedstoneUraniumRodSingle);
                ClassicRecipes.canningMachine.registerCannerItem(emptyFuelRod, (IRecipeInput)new RecipeInputItemStack(Ic2Items.blazeUraniumIngot), Ic2Items.reactorBlazeUraniumRodSingle);
                ClassicRecipes.canningMachine.registerCannerItem(emptyFuelRod, (IRecipeInput)new RecipeInputItemStack(Ic2Items.enderPearlUraniumIngot), Ic2Items.reactorEnderPearlUraniumRodSingle);
                ClassicRecipes.canningMachine.registerCannerItem(emptyFuelRod, (IRecipeInput)new RecipeInputItemStack(Ic2Items.netherStarUraniumIngot), Ic2Items.reactorNetherStarUraniumRodSingle);
                ClassicRecipes.canningMachine.registerCannerItem(emptyFuelRod, (IRecipeInput)new RecipeInputItemStack(Ic2Items.charcoalUraniumIngot), Ic2Items.reactorCharcoalUraniumRodSingle);
            }
        }
    }

    public static void initShapelessRecipes() {
        FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
        recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.bronzeDust, (int)4), new Object[]{crushedCopper, crushedCopper, crushedCopper, crushedTin});
        recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.constructionFoam, (int)4), new Object[]{water, "dustRedstone", "dustCoal", "dustStone", "dustStone", "dustStone"});
        recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.constructionFoam, (int)4), new Object[]{water, "dustRedstone", "dustCharcoal", "dustStone", "dustStone", "dustStone"});
        recipes.addShapelessRecipe(new ItemStack((Item)Registry.stoneDust, 4), new Object[]{Registry.stoneDustBlock});
        if (Ic2cExtrasConfig.craftingCablesWithPlates) {
            int tinAmount;
            boolean e = Ic2cExtrasConfig.plateCablesMakeLessThenExtruder;
            int copperBronzeAmount = e ? 2 : 3;
            int goldHVAmount = e ? 4 : 6;
            int n = tinAmount = e ? 3 : 4;
            if (Ic2cExtrasConfig.plateCablesOverrideRegularCables) {
                Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.itemcable_-895690168");
                Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.itemgoldcable_-121137345");
                Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.itemironcable_1314416875");
                Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.itemironcable_-1596711841");
                Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.itemtincable_1475909484");
                Ic2cExtrasRecipes.removeRecipe("ic2", "shaped_item.itembronzecable_1006731162");
            }
            recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.copperCable, (int)copperBronzeAmount), new Object[]{"plateCopper", "craftingToolWireCutter"});
            recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.goldCable, (int)goldHVAmount), new Object[]{"plateGold", "craftingToolWireCutter"});
            recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.tinCable, (int)tinAmount), new Object[]{"plateTin", "craftingToolWireCutter"});
            recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.bronzeCable, (int)copperBronzeAmount), new Object[]{"plateBronze", "craftingToolWireCutter"});
            if (!IC2.config.getFlag("SteelRecipes")) {
                if (Ic2cExtrasConfig.cablesTakeSteel) {
                    recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.ironCable, (int)goldHVAmount), new Object[]{"plateSteel", "craftingToolWireCutter"});
                } else {
                    recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.ironCable, (int)goldHVAmount), new Object[]{"plateRefinedIron", "craftingToolWireCutter"});
                }
            } else {
                recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.ironCable, (int)goldHVAmount), new Object[]{"plateSteel", "craftingToolWireCutter"});
            }
        }
        if (Ic2cExtrasConfig.craftingHammerRecipes) {
            if (Ic2cExtrasConfig.casingsRequirePlates) {
                if (!Loader.isModLoaded((String)"gtc_expansion")) {
                    recipes.addRecipe(new ItemStack((Item)Registry.copperPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotCopper", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.tinPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotTin", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.silverPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotSilver", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.leadPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotLead", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.ironPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotIron", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.goldPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotGold", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.refinedIronPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotRefinedIron", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.steelPlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotSteel", Character.valueOf('H'), "craftingToolForgeHammer"});
                    recipes.addRecipe(new ItemStack((Item)Registry.bronzePlate, 1), new Object[]{"H", "I", Character.valueOf('I'), "ingotBronze", Character.valueOf('H'), "craftingToolForgeHammer"});
                }
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.copperCasing, 2), new Object[]{"plateCopper", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.tinCasing, 2), new Object[]{"plateTin", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.silverCasing, 2), new Object[]{"plateSilver", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.leadCasing, 2), new Object[]{"plateLead", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.ironCasing, 2), new Object[]{"plateIron", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.goldCasing, 2), new Object[]{"plateGold", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.refinedIronCasing, 2), new Object[]{"plateRefinedIron", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.steelCasing, 2), new Object[]{"plateSteel", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.bronzeCasing, 2), new Object[]{"plateBronze", "craftingToolForgeHammer"});
            } else {
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.copperCasing, 2), new Object[]{"ingotCopper", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.tinCasing, 2), new Object[]{"ingotTin", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.silverCasing, 2), new Object[]{"ingotSilver", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.leadCasing, 2), new Object[]{"ingotLead", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.ironCasing, 2), new Object[]{"ingotIron", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.goldCasing, 2), new Object[]{"ingotGold", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.refinedIronCasing, 2), new Object[]{"ingotRefinedIron", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.steelCasing, 2), new Object[]{"ingotSteel", "craftingToolForgeHammer"});
                recipes.addShapelessRecipe(new ItemStack((Item)Registry.bronzeCasing, 2), new Object[]{"ingotBronze", "craftingToolForgeHammer"});
            }
        }
    }

    public static void dustUtil(String dust, ItemStack dusts, String tinyDust, ItemStack tinyDusts) {
        recipes.addRecipe(StackUtil.copyWithSize((ItemStack)dusts, (int)1), new Object[]{"TTT", "TTT", "TTT", Character.valueOf('T'), tinyDust});
        recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)tinyDusts, (int)9), new Object[]{dust});
    }

    public static void dustUtil(String dust, ItemStack dusts, String tinyDust, ItemStack tinyDusts, String smallDust, ItemStack smallDusts) {
        recipes.addRecipe(StackUtil.copyWithSize((ItemStack)dusts, (int)1), new Object[]{"TTT", "TTT", "TTT", Character.valueOf('T'), tinyDust});
        recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)tinyDusts, (int)9), new Object[]{dust});
        recipes.addRecipe(StackUtil.copyWithSize((ItemStack)dusts, (int)1), new Object[]{"SS", "SS", Character.valueOf('S'), smallDust});
        recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)smallDusts, (int)4), new Object[]{dust});
    }

    public static void ingotUtil(String block, Block blocks, String ingot, ItemStack ingots) {
        recipes.addRecipe(new ItemStack(blocks, 1), new Object[]{"III", "III", "III", Character.valueOf('I'), ingot});
        recipes.addShapelessRecipe(StackUtil.copyWithSize((ItemStack)ingots, (int)9), new Object[]{block});
    }

    public static void initCompressRecipes() {
        CraftingRecipes.dustUtil("dustIron", Ic2Items.ironDust, "dustTinyIron", new ItemStack((Item)Registry.ironTinyDust), "dustSmallIron", new ItemStack((Item)Registry.ironSmallDust));
        CraftingRecipes.dustUtil("dustGold", Ic2Items.goldDust, "dustTinyGold", new ItemStack((Item)Registry.goldTinyDust), "dustSmallGold", new ItemStack((Item)Registry.goldSmallDust));
        CraftingRecipes.dustUtil("dustCopper", Ic2Items.copperDust, "dustTinyCopper", new ItemStack((Item)Registry.copperTinyDust), "dustSmallCopper", new ItemStack((Item)Registry.copperSmallDust));
        CraftingRecipes.dustUtil("dustTin", Ic2Items.tinDust, "dustTinyTin", new ItemStack((Item)Registry.tinTinyDust), "dustSmallTin", new ItemStack((Item)Registry.tinSmallDust));
        CraftingRecipes.dustUtil("dustSilver", Ic2Items.silverDust, "dustTinySilver", new ItemStack((Item)Registry.silverTinyDust), "dustSmallSilver", new ItemStack((Item)Registry.silverSmallDust));
        CraftingRecipes.dustUtil("dustLead", new ItemStack((Item)Registry.leadDust), "dustTinyLead", new ItemStack((Item)Registry.leadTinyDust), "dustSmallLead", new ItemStack((Item)Registry.leadSmallDust));
        CraftingRecipes.dustUtil("dustObsidian", Ic2Items.obsidianDust, "dustTinyObsidian", new ItemStack((Item)Registry.obsidianTinyDust), "dustSmallObsidian", new ItemStack((Item)Registry.obsidianSmallDust));
        CraftingRecipes.dustUtil("dustBronze", Ic2Items.bronzeDust, "dustTinyBronze", new ItemStack((Item)Registry.bronzeTinyDust), "dustSmallBronze", new ItemStack((Item)Registry.bronzeSmallDust));
        recipes.addRecipe(Ic2Items.iridiumOre, new Object[]{"III", "III", "III", Character.valueOf('I'), Registry.iridiumShard});
        recipes.addShapelessRecipe(new ItemStack((Item)Registry.iridiumShard, 9), new Object[]{Ic2Items.iridiumOre});
        CraftingRecipes.ingotUtil("blockSteel", Registry.steelBlock, "ingotSteel", new ItemStack((Item)Registry.steelIngot));
        CraftingRecipes.ingotUtil("blockLead", Registry.leadBlock, "ingotLead", new ItemStack((Item)Registry.leadIngot));
        CraftingRecipes.ingotUtil("blockRefinedIron", Registry.refinedIronBlock, "ingotRefinedIron", Ic2Items.refinedIronIngot);
    }
}

