/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.util;

import info.loenwind.autosave.util.NonnullType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;

public class VersionProxy<T> {
    private static final GameVersion VERSION = GameVersion.discover();
    @Nonnull
    private final T func;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final MethodHandle NBTUtil$writeBlockState;
    public static final VersionProxy<Function<@NonnullType IBlockState, @NonnullType NBTTagCompound>> WRITE_BLOCKSTATE;
    private static final MethodHandle ItemStack$read;
    public static final VersionProxy<Function<@NonnullType NBTTagCompound, @NonnullType ItemStack>> READ_ITEMSTACK;
    public static final VersionProxy<BiConsumer<@NonnullType NBTTagList, @NonnullType Object>> NBTTAGLIST_ADD;
    public static final VersionProxy<ToIntFunction<@NonnullType NBTTagList>> NBTTAGLIST_SIZE;

    VersionProxy(T func) {
        this.func = func;
    }

    public T get() {
        return this.func;
    }

    static {
        try {
            switch (VERSION) {
                default: {
                    NBTUtil$writeBlockState = null;
                    break;
                }
                case V1_13_x: {
                    NBTUtil$writeBlockState = LOOKUP.findStatic(NBTUtil.class, "func_190009_a", MethodType.methodType(NBTTagCompound.class, IBlockState.class));
                    break;
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        WRITE_BLOCKSTATE = new VersionProxy<Function<IBlockState, NBTTagCompound>>(s -> {
            if (NBTUtil$writeBlockState != null) {
                try {
                    return NBTUtil$writeBlockState.invokeExact((IBlockState)s);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)tag, (IBlockState)s);
            return tag;
        });
        try {
            switch (VERSION) {
                default: {
                    ItemStack$read = null;
                    break;
                }
                case V1_13_x: {
                    ItemStack$read = LOOKUP.findStatic(ItemStack.class, "func_199557_a", MethodType.methodType(ItemStack.class, NBTTagCompound.class));
                    break;
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        READ_ITEMSTACK = new VersionProxy<Function<NBTTagCompound, ItemStack>>(t -> {
            if (ItemStack$read != null) {
                try {
                    return ItemStack$read.invokeExact((NBTTagCompound)t);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return new ItemStack(t);
        });
        NBTTAGLIST_ADD = new VersionProxy<BiConsumer<NBTTagList, Object>>((tag, obj) -> {
            switch (VERSION) {
                default: {
                    tag.func_74742_a((NBTBase)obj);
                    break;
                }
                case V1_13_x: {
                    ((List)tag).add(obj);
                    return;
                }
            }
        });
        NBTTAGLIST_SIZE = new VersionProxy<ToIntFunction<NBTTagList>>(tag -> {
            switch (VERSION) {
                default: {
                    return tag.func_74745_c();
                }
                case V1_13_x: 
            }
            return ((List)tag).size();
        });
    }

    static enum GameVersion {
        BEFORE_1_13,
        V1_13_x;


        static GameVersion discover() {
            try {
                Class.forName("net.minecraftforge.fml.common.FMLCommonHandler");
                return BEFORE_1_13;
            }
            catch (ClassNotFoundException e) {
                return V1_13_x;
            }
        }
    }
}

