/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.diona.tileentity;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.utils.dimension.IDarkEnergyProvider;
import stevekung.mods.moreplanets.utils.items.IDarkEnergyFuel;

public class TileEntityDarkEnergyGenerator
extends TileBaseUniversalElectricalSource
implements IDisableableMachine,
IConnector {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int generateWatts = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int darkEnergyFuel = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int prevDarkEnergyFuel = 0;
    public int renderTicks;
    private boolean initialize = true;

    public TileEntityDarkEnergyGenerator() {
        super("container.dark_energy_generator.name");
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        this.storage.setMaxExtract(2500.0f);
        this.storage.setMaxReceive(2500.0f);
        this.storage.setCapacity(500000.0f);
    }

    public int getPacketCooldown() {
        return 1;
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.renderTicks;
        if (this.initialize) {
            this.renderTicks += this.field_145850_b.field_73012_v.nextInt(100);
            this.initialize = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.receiveEnergyGC(null, this.generateWatts, false);
            this.recharge((ItemStack)this.getInventory().get(0));
            this.recharge((ItemStack)this.getInventory().get(1));
            ItemStack darkEnergy = (ItemStack)this.getInventory().get(2);
            if (!this.disabled) {
                if (this.ticks % 20 == 0 && this.darkEnergyFuel > 0) {
                    --this.darkEnergyFuel;
                }
                if (!darkEnergy.func_190926_b() && this.darkEnergyFuel <= 0 && darkEnergy.func_77973_b() instanceof IDarkEnergyFuel) {
                    this.prevDarkEnergyFuel = this.darkEnergyFuel = ((IDarkEnergyFuel)darkEnergy.func_77973_b()).getDarkEnergyFuel();
                    darkEnergy.func_190918_g(1);
                }
            }
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if ((float)this.getGenerate() > 0.0f) {
                this.ticks += this.field_145850_b.field_73012_v.nextInt(2);
                if (this.ticks % 33 == 0) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), MPSounds.MACHINE_GENERATOR_AMBIENT, SoundCategory.BLOCKS, 0.05f, 1.0f);
                }
                this.generateWatts = Math.min(Math.max(this.getGenerate(), 0), 1500);
            } else {
                this.generateWatts = 0;
            }
        }
        this.produce();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("MaxEnergy"));
        this.setDisabled(0, nbt.func_74767_n("Disabled"));
        this.disableCooldown = nbt.func_74762_e("DisabledCooldown");
        this.darkEnergyFuel = nbt.func_74762_e("DarkEnergyFuel");
        this.prevDarkEnergyFuel = nbt.func_74762_e("PrevDarkEnergyFuel");
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.getInventory());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("MaxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74768_a("DisabledCooldown", this.disableCooldown);
        nbt.func_74757_a("Disabled", this.getDisabled(0));
        nbt.func_74768_a("DarkEnergyFuel", this.darkEnergyFuel);
        nbt.func_74768_a("PrevDarkEnergyFuel", this.prevDarkEnergyFuel);
        return nbt;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(EnumFacing.DOWN);
    }

    public EnumFacing getElectricOutputDirection() {
        return EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 2));
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 0;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        return slotID == 0 || slotID == 1;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 2) {
            return itemStack.func_77973_b() == MPItems.DARK_ENERGY_PEARL;
        }
        return (slotID == 0 || slotID == 1) && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricOutputDirection();
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    private int getGenerate() {
        if (this.getDisabled(0)) {
            return 0;
        }
        return this.field_145850_b.field_73011_w instanceof IDarkEnergyProvider ? ((IDarkEnergyProvider)this.field_145850_b.field_73011_w).getDarkEnergyMultiplier(this.field_145850_b, this.field_174879_c) + this.darkEnergyFuel : 100 + this.darkEnergyFuel;
    }
}

