/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql.mysql;

import com.zaxxer.hikari.HikariDataSource;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLAbstractProvider;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.sql.SqlService;

public class MySQLProvider
extends SQLAbstractProvider
implements SQLProvider {
    private static MySQLProvider INSTANCE = null;
    private DataSource dataSource;

    public static MySQLProvider getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new MySQLProvider(eagleFactions);
                return INSTANCE;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return INSTANCE;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public String getProviderName() {
        return "mysql";
    }

    private MySQLProvider(EagleFactions eagleFactions) throws SQLException {
        super(eagleFactions);
        SqlService sqlService = (SqlService)Sponge.getServiceManager().provideUnchecked(SqlService.class);
        this.dataSource = sqlService.getDataSource("jdbc:mysql://" + super.getUsername() + ":" + super.getPassword() + "@" + super.getDatabaseUrl() + "?useUnicode=true&useSSL=false&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC");
        if (!this.databaseExists()) {
            this.createDatabase();
        }
        HikariDataSource hikariDataSource = this.dataSource.unwrap(HikariDataSource.class);
        hikariDataSource.close();
        this.dataSource = sqlService.getDataSource("jdbc:mysql://" + super.getUsername() + ":" + super.getPassword() + "@" + super.getDatabaseUrl() + super.getDatabaseName() + "?useUnicode=true&useSSL=false&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC");
    }

    private boolean databaseExists() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             ResultSet resultSet = connection.getMetaData().getCatalogs();){
            while (resultSet.next()) {
                if (!resultSet.getString(1).equalsIgnoreCase(super.getDatabaseName())) continue;
                resultSet.close();
                connection.close();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void createDatabase() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE SCHEMA " + super.getDatabaseName() + ";");
        }
    }
}

