/*
 * Decompiled with CFR 0.152.
 */
package net.dirtcraft.julian;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public class ConfigManager {
    private static Path dir;
    private static Path config;
    private static CommentedConfigurationNode confNode;
    private static ConfigurationLoader<CommentedConfigurationNode> confLoad;
    private static final String CFG = "Slash-Discord.conf";

    public static void setup(Path folder) {
        dir = folder;
        config = dir.resolve(CFG);
    }

    public static void load() {
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
                confLoad = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(config)).build();
                confNode = (CommentedConfigurationNode)confLoad.load();
                ConfigManager.addValues();
                ConfigManager.save();
            } else {
                confLoad = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(config)).build();
                confNode = (CommentedConfigurationNode)confLoad.load();
                ConfigManager.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            confLoad.save((ConfigurationNode)confNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addValues() {
        confNode.getNode(new Object[]{"Discord", "message"}).setValue((Object)"&6&lJoin us on Discord").setComment("Customize your message here");
        confNode.getNode(new Object[]{"Discord", "discordlink"}).setValue((Object)"https://discord.gg/mGgfyaS").setComment("Insert Discord link here");
        confNode.getNode(new Object[]{"Discord", "prefix"}).setValue((Object)"&9&l\u00bb ").setComment("Insert prefix before message and link here");
        confNode.getNode(new Object[]{"Discord", "hover"}).setValue((Object)"&6Click me to join our Discord!").setComment("Insert text when hovering over link here");
        confNode.getNode(new Object[]{"Pagination", "header"}).setValue((Object)"&cDiscord Server").setComment("Insert your pagination header here");
        confNode.getNode(new Object[]{"Pagination", "padding"}).setValue((Object)"&7&m-").setComment("Insert your pagination padding here");
    }

    public static CommentedConfigurationNode getConfNode(Object ... node) {
        return confNode.getNode(node);
    }
}

