/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.processor.PrepaireProgress;

public class PrepaireEntry
extends InfoEntry {
    long prepare;
    long prepareMax;

    public PrepaireEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "Prepare Info";
    }

    @Override
    public boolean shouldRender() {
        return this.prepareMax > 0L;
    }

    @Override
    public void write(IWriteableBuffer buf) {
        PrepaireProgress process = this.getProcessor().progress;
        buf.writeLong(process.getCurrent());
        buf.writeLong(process.getMax());
    }

    @Override
    public void read(IReadableBuffer buf) {
        this.prepare = buf.readLong();
        this.prepareMax = buf.readLong();
    }

    @Override
    public int currentValue() {
        return this.prepare >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.prepare;
    }

    @Override
    public int maxValue() {
        return this.prepareMax >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.prepareMax;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        helper.renderBar(x - width / 2, y, width, (int)((double)this.prepare / (double)this.prepareMax * (double)width), "Prepare: " + this.prepare + " / " + this.prepareMax);
    }
}

