/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui;

import com.sintinium.oauth.OAuthConfig;
import com.sintinium.oauth.gui.ActionButton;
import com.sintinium.oauth.gui.OAuthCheckbox;
import com.sintinium.oauth.gui.PasswordFieldWidget;
import com.sintinium.oauth.gui.ResponsiveButton;
import com.sintinium.oauth.gui.UsernameFieldWidget;
import com.sintinium.oauth.login.LoginUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import org.lwjgl.input.Keyboard;

public class LoginScreen
extends GuiScreen {
    private final GuiScreen lastScreen;
    private final GuiMultiplayer multiplayerScreen;
    private ActionButton mojangLoginButton;
    private PasswordFieldWidget passwordWidget;
    private OAuthCheckbox savePasswordWidget;
    private GuiTextField usernameWidget;
    private AtomicReference<String> status = new AtomicReference();
    private String title = "OAuth Login";
    private GuiPageButtonList.GuiResponder guiResponder = new GuiPageButtonList.GuiResponder(){

        public void func_175321_a(int id, boolean value) {
            LoginScreen.this.onEdited(id, String.valueOf(value));
        }

        public void func_175320_a(int id, float value) {
            LoginScreen.this.onEdited(id, String.valueOf(value));
        }

        public void func_175319_a(int id, String value) {
            LoginScreen.this.onEdited(id, value);
        }
    };
    private List<Runnable> toRun = new CopyOnWriteArrayList<Runnable>();

    public LoginScreen(GuiScreen last, GuiMultiplayer multiplayerScreen) {
        this.lastScreen = last;
        this.multiplayerScreen = multiplayerScreen;
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        String user = this.usernameWidget.func_146179_b();
        String pass = this.passwordWidget.getText();
        super.func_175273_b(mcIn, w, h);
        this.func_73866_w_();
        this.usernameWidget.func_146180_a(user);
        this.passwordWidget.setText(pass);
    }

    public void func_73876_c() {
        this.usernameWidget.func_146178_a();
        this.passwordWidget.updateCursorCounter();
        if (!this.toRun.isEmpty()) {
            for (Runnable r : this.toRun) {
                r.run();
            }
            this.toRun.clear();
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.passwordWidget = new PasswordFieldWidget(0, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 20, 200, 20);
        this.passwordWidget.setMaxStringLength(128);
        this.passwordWidget.setGuiResponder(this.guiResponder);
        this.usernameWidget = new UsernameFieldWidget(1, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 60, 200, 20, this.passwordWidget);
        this.usernameWidget.func_146195_b(true);
        if (LoginUtil.lastMojangUsername != null) {
            this.usernameWidget.func_146180_a(LoginUtil.lastMojangUsername);
        }
        this.usernameWidget.func_175207_a(this.guiResponder);
        this.savePasswordWidget = (OAuthCheckbox)this.func_189646_b((GuiButton)new OAuthCheckbox(4, this.field_146294_l / 2 - this.field_146289_q.func_78256_a("Save password") - 25, this.field_146295_m / 2 + 1 + 2, "Save password", false));
        Runnable savePw = () -> {
            if (this.savePasswordWidget.isChecked()) {
                this.saveLoginInfo();
            } else {
                this.removeLoginInfo();
            }
        };
        this.mojangLoginButton = (ActionButton)this.func_189646_b(new ResponsiveButton(2, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 36, 200, 20, "Login", () -> {
            Thread thread = new Thread(() -> {
                if (this.usernameWidget.func_146179_b().isEmpty()) {
                    this.toRun.add(() -> this.status.set("Missing username!"));
                } else {
                    Optional<Boolean> didSuccessfullyLogIn = LoginUtil.loginMojangOrLegacy(this.usernameWidget.func_146179_b(), this.passwordWidget.getText());
                    savePw.run();
                    if (!didSuccessfullyLogIn.isPresent()) {
                        this.toRun.add(() -> this.status.set("You seem to be offline. Check your connection!"));
                    } else if (!didSuccessfullyLogIn.get().booleanValue()) {
                        this.toRun.add(() -> this.status.set("Wrong password or username!"));
                    } else {
                        LoginUtil.updateOnlineStatus();
                        this.toRun.add(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)this.multiplayerScreen));
                    }
                }
            });
            thread.start();
        }, this::updateLoginButton, () -> {
            this.mojangLoginButton.field_146126_j = "Login";
        }));
        this.func_189646_b(new ActionButton(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 60, 200, 20, "Cancel", () -> {
            if (!this.savePasswordWidget.isChecked()) {
                this.removeLoginInfo();
            }
            Minecraft.func_71410_x().func_147108_a(this.lastScreen);
        }));
        this.cleanUp();
        if (OAuthConfig.isSavedPassword()) {
            this.usernameWidget.func_146180_a(OAuthConfig.getUsername());
            this.passwordWidget.setText(OAuthConfig.getPassword());
            this.savePasswordWidget.setIsChecked(true);
        }
    }

    private void saveLoginInfo() {
        OAuthConfig.setUsername(this.usernameWidget.func_146179_b());
        OAuthConfig.setPassword(this.passwordWidget.getText());
        ConfigManager.sync((String)"oauth", (Config.Type)Config.Type.INSTANCE);
    }

    private void removeLoginInfo() {
        OAuthConfig.removeUsernamePassword();
        ConfigManager.sync((String)"oauth", (Config.Type)Config.Type.INSTANCE);
    }

    private void onEdited(int id, String value) {
        this.cleanUp();
    }

    private void updateLoginButton() {
        this.mojangLoginButton.field_146126_j = this.passwordWidget.getText().isEmpty() ? "Login Offline" : "Login";
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void cleanUp() {
        this.mojangLoginButton.field_146124_l = !this.usernameWidget.func_146179_b().isEmpty();
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ActionButton) {
            ((ActionButton)button).onClicked();
        } else if (!(button instanceof OAuthCheckbox)) {
            throw new RuntimeException("Missing button action");
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.usernameWidget.func_146201_a(typedChar, keyCode);
        this.passwordWidget.textboxKeyTyped(typedChar, keyCode);
        if (keyCode == 15) {
            this.usernameWidget.func_146195_b(!this.passwordWidget.isFocused());
            this.passwordWidget.setFocused(!this.usernameWidget.func_146206_l());
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.usernameWidget.func_146192_a(mouseX, mouseY, mouseButton);
        this.passwordWidget.mouseClicked(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.func_73732_a(this.field_146297_k.field_71466_p, this.title, this.field_146294_l / 2, 17, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, "Username/Email", this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 60 - 12, 0xA0A0A0);
        this.func_73731_b(this.field_146297_k.field_71466_p, "Password", this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 20 - 12, 0xA0A0A0);
        if (this.status.get() != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, this.status.get(), this.field_146294_l / 2, this.field_146295_m / 2 + 20, 0xFF0000);
        }
        this.usernameWidget.func_146194_f();
        this.passwordWidget.drawTextBox();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

