/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.components.VariableColor;
import vswe.superfactory.interfaces.GuiManager;

public abstract class VariableDisplay {
    private static final int ARROW_HEIGHT = 10;
    private static final int ARROW_SRC_X = 18;
    private static final int ARROW_SRC_Y = 20;
    private static final int ARROW_WIDTH = 6;
    private static final int ARROW_X_RIGHT = 38;
    private static final int ARROW_Y = 3;
    private static final int TEXT_X = -40;
    private static final int TEXT_Y = 5;
    private static final int VARIABLE_SIZE = 14;
    private static final int VARIABLE_X = 15;
    private Localization name;
    private int x;
    private int y;

    protected VariableDisplay(Localization name, int x, int y) {
        this.name = name;
        this.x = x;
        this.y = y;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        if (this.name != null) {
            gui.drawString(this.name.toString(), this.x + -40, this.y + 5, 0x404040);
        }
        gui.getManager().getVariables()[this.getValue()].draw(gui, this.x + 15, this.y);
        for (int i = 0; i < 2; ++i) {
            int posX = this.x + (i == 0 ? 0 : 38);
            int posY = this.y + 3;
            int srcXArrow = i;
            int srcYArrow = CollisionHelper.inBounds(posX, posY, 6, 10, mX, mY) ? 1 : 0;
            gui.drawTexture(posX, posY, 18 + srcXArrow * 6, 20 + srcYArrow * 10, 6, 10);
        }
    }

    public abstract int getValue();

    public abstract void setValue(int var1);

    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        if (CollisionHelper.inBounds(this.x + 15, this.y, 14, 14, mX, mY)) {
            gui.drawMouseOver(gui.getManager().getVariables()[this.getValue()].getDescription(gui), mX, mY);
        }
    }

    public void onClick(int mX, int mY) {
        for (int i = -1; i <= 1; i += 2) {
            int posY;
            int posX = this.x + (i == 1 ? 38 : 0);
            if (!CollisionHelper.inBounds(posX, posY = this.y + 3, 6, 10, mX, mY)) continue;
            int val = this.getValue();
            if ((val += i) < 0) {
                val = VariableColor.values().length - 1;
            } else if (val == VariableColor.values().length) {
                val = 0;
            }
            this.setValue(val);
            this.onUpdate();
            break;
        }
    }

    public abstract void onUpdate();
}

