/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;

public class TemplateInclusion {
    public String template;
    public String as;
    @SerializedName(value="using")
    public Map<String, String> map = new HashMap<String, String>();
    public int x;
    public int y;
    transient List<String> visitedTemplates = new ArrayList<String>();

    public void upperMerge(TemplateInclusion upper) {
        if (upper == null) {
            return;
        }
        if (upper.visitedTemplates.contains(this.template)) {
            throw new IllegalArgumentException("Breaking when include template " + this.template + ", circular dependencies aren't allowed (stack = " + upper.visitedTemplates + ")");
        }
        this.visitedTemplates = new ArrayList<String>(upper.visitedTemplates);
        this.visitedTemplates.add(this.template);
        this.as = upper.realName(this.as);
        this.x += upper.x;
        this.y += upper.y;
        Set<String> keys = this.map.keySet();
        for (String key : keys) {
            String realVal;
            String val = this.map.get(key);
            if (!val.startsWith("#") || !upper.map.containsKey(realVal = val.substring(1))) continue;
            this.map.put(key, upper.map.get(realVal));
        }
    }

    public void process(IComponentProcessor processor) {
        if (processor == null) {
            return;
        }
        Set<String> keys = this.map.keySet();
        for (String key : keys) {
            String realVal;
            String res;
            String val = this.map.get(key);
            if (!val.startsWith("#") || (res = processor.process(realVal = val.substring(1))) == null) continue;
            this.map.put(key, res);
        }
    }

    private String realName(String name) {
        if (name.isEmpty()) {
            return this.as;
        }
        return this.as + "." + name;
    }

    public String transform(String var, boolean prefixedOnly) {
        boolean isPrefixed = var.startsWith("#");
        if (!prefixedOnly || isPrefixed) {
            String key;
            String string = key = isPrefixed ? var.substring(1) : var;
            if (this.map.containsKey(key)) {
                return this.map.get(key);
            }
            return (isPrefixed ? "#" : "") + this.realName(key);
        }
        return var;
    }

    public IVariableProvider<String> wrapProvider(final IVariableProvider<String> provider) {
        return new IVariableProvider<String>(){

            @Override
            public boolean has(String key) {
                String transformed = TemplateInclusion.this.transform(key, false);
                return !transformed.startsWith("#") || provider.has(transformed.substring(1));
            }

            @Override
            public String get(String key) {
                String transformed = TemplateInclusion.this.transform(key, false);
                return transformed.startsWith("#") ? (String)provider.get(transformed.substring(1)) : transformed;
            }
        };
    }
}

