/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMappingException;
import me.lucko.luckperms.lib.configurate.objectmapping.serialize.TypeSerializer;
import me.lucko.luckperms.lib.configurate.util.EnumLookup;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class EnumValueSerializer
implements TypeSerializer<Enum<?>> {
    EnumValueSerializer() {
    }

    @Override
    public Enum<?> deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        String enumConstant = value.getString();
        if (enumConstant == null) {
            throw new ObjectMappingException("No value present in node " + value);
        }
        Optional<Enum> ret = EnumLookup.lookupEnum(type.getRawType().asSubclass(Enum.class), enumConstant);
        if (!ret.isPresent()) {
            throw new ObjectMappingException("Invalid enum constant provided for " + value.getKey() + ": Expected a value of enum " + type + ", got " + enumConstant);
        }
        return ret.get();
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable Enum<?> obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        value.setValue(obj == null ? null : obj.name());
    }
}

