/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import me.lucko.luckperms.lib.configurate.ConfigValue;
import me.lucko.luckperms.lib.configurate.SimpleConfigurationNode;
import me.lucko.luckperms.lib.configurate.ValueType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ScalarConfigValue
extends ConfigValue {
    private volatile Object value;

    ScalarConfigValue(SimpleConfigurationNode holder) {
        super(holder);
    }

    @Override
    ValueType getType() {
        return ValueType.SCALAR;
    }

    @Override
    public @Nullable Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(@Nullable Object value) {
        if (!this.holder.getOptions().acceptsType(Objects.requireNonNull(value).getClass())) {
            throw new IllegalArgumentException("Configuration does not accept objects of type " + value.getClass());
        }
        this.value = value;
    }

    @Override
    @Nullable SimpleConfigurationNode putChild(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        return null;
    }

    @Override
    @Nullable SimpleConfigurationNode putChildIfAbsent(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        return null;
    }

    @Override
    public @Nullable SimpleConfigurationNode getChild(@Nullable Object key) {
        return null;
    }

    @Override
    public @NonNull Iterable<SimpleConfigurationNode> iterateChildren() {
        return Collections.emptySet();
    }

    @Override
    @NonNull ScalarConfigValue copy(@NonNull SimpleConfigurationNode holder) {
        ScalarConfigValue copy = new ScalarConfigValue(holder);
        copy.value = this.value;
        return copy;
    }

    @Override
    boolean isEmpty() {
        Object value = this.value;
        return value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty();
    }

    @Override
    public void clear() {
        this.value = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarConfigValue that = (ScalarConfigValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return 7 + Objects.hashCode(this.value);
    }

    public String toString() {
        return "ScalarConfigValue{value=" + this.value + '}';
    }
}

