/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.advert;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.Advert;
import net.malisis.advert.network.AdvertDownloadMessage;
import net.malisis.core.util.Silenced;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.commons.lang3.StringUtils;

public class ServerAdvert
extends Advert {
    private static File packDir = new File("./" + advertDir);
    private static ListeningExecutorService threadPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
    private static ListenableFuture<Void> task;
    private static Set<EntityPlayer> listeners;
    private static SortedMap<Integer, ServerAdvert> adverts;
    private static String advertListing;
    private static int globalId;

    public ServerAdvert(int id) {
        super(id);
    }

    @Override
    public void setInfos(String name, String url) {
        boolean newUrl;
        boolean bl = newUrl = this.url != null && !StringUtils.equals((CharSequence)this.url, (CharSequence)url);
        if (newUrl && this.file != null) {
            this.file.delete();
            this.file = null;
        }
        super.setInfos(name, url);
        if (newUrl) {
            this.downloadFile();
        }
    }

    @Override
    public void save() {
        super.save();
        adverts.put(this.id, this);
        ServerAdvert.writeListing();
    }

    @Override
    public void delete() {
        super.delete();
        adverts.remove(this.id);
        ServerAdvert.writeListing();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.url);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.hash != null ? this.hash : ""));
        buf.writeLong(this.size);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
    }

    public void downloadAdvert(EntityPlayer player) {
        listeners.add(player);
        this.downloadFile();
    }

    private boolean checkOldFile() {
        File f = new File(advertDir, "" + this.id);
        if (!f.exists()) {
            return false;
        }
        byte[] img = (byte[])Silenced.get(() -> Files.toByteArray((File)f));
        f.delete();
        this.writeFile(img);
        ServerAdvert.writeListing();
        return true;
    }

    @Override
    protected void downloadFile() {
        if (this.checkOldFile()) {
            return;
        }
        if (task != null && !task.isDone()) {
            return;
        }
        task = threadPool.submit(() -> {
            byte[] img = null;
            try {
                img = Resources.toByteArray((URL)new URL(this.url));
            }
            catch (Exception e) {
                this.setError(e.getMessage());
                MalisisAdvert.log.error((Object)e);
            }
            this.writeFile(img);
            ServerAdvert.writeListing();
            this.sendImageData();
            return null;
        });
    }

    private void sendImageData() {
        for (EntityPlayer player : listeners) {
            AdvertDownloadMessage.sendImageData(this, player);
        }
        listeners.clear();
    }

    public static ServerAdvert get(int id) {
        return ServerAdvert.get(id, false);
    }

    public static ServerAdvert get(int id, boolean create) {
        ServerAdvert advert = (ServerAdvert)adverts.get(id);
        if (advert == null || id == 0) {
            if (create) {
                advert = new ServerAdvert(globalId++);
            } else {
                MalisisAdvert.log.error("Cannot find Advert {} for server", (Object)id);
            }
        }
        return advert;
    }

    public static Collection<ServerAdvert> listAdverts() {
        return adverts.values();
    }

    public static int getAdvertCount() {
        return adverts.size();
    }

    public static void readListing() {
        File listing = new File(packDir, advertListing);
        if (!listing.exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(listing));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] parts = line.split(";");
                if (parts.length != 3 && parts.length != 4) continue;
                int id = Integer.decode(parts[0]);
                ServerAdvert advert = new ServerAdvert(id);
                advert.setInfos(parts[1], parts[2]);
                if (parts.length == 4) {
                    advert.setHash(parts[3]);
                }
                adverts.put(id, advert);
                if (id < globalId) continue;
                globalId = id + 1;
            }
        }
        catch (IOException e) {
            MalisisAdvert.log.error("Could not read advert listing file : ", (Throwable)e);
        }
    }

    public static void writeListing() {
        File listing = new File(packDir, advertListing);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(listing));){
            for (ServerAdvert advert : adverts.values()) {
                bw.write(advert.id + ";" + advert.name + ";" + advert.url + ";" + advert.hash + "\r\n");
            }
        }
        catch (IOException e) {
            MalisisAdvert.log.error("Could not write advert listing file : ", (Throwable)e);
        }
    }

    static {
        listeners = new HashSet<EntityPlayer>();
        adverts = new TreeMap<Integer, ServerAdvert>();
        advertListing = "listing.txt";
        globalId = 1;
        if (!packDir.exists()) {
            packDir.mkdir();
        }
        ServerAdvert.readListing();
    }
}

