/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis.buttons;

import net.minecraft.entity.player.EntityPlayer;
import vswe.stevescarts.computer.ComputerProg;
import vswe.stevescarts.computer.ComputerTask;
import vswe.stevescarts.guis.buttons.ButtonAssembly;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.modules.workers.ModuleComputer;

public class ButtonTaskType
extends ButtonAssembly {
    private int typeId;

    public ButtonTaskType(ModuleComputer module, ButtonBase.LOCATION loc, int id) {
        super(module, loc);
        this.typeId = id;
    }

    @Override
    public String toString() {
        if (this.haveTasks()) {
            return "Change to " + ComputerTask.getTypeName(this.typeId);
        }
        return "Add " + ComputerTask.getTypeName(this.typeId) + " task";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public int texture() {
        if (this.typeId < 4) {
            return this.typeId * 2 + (this.haveTasks() ? 1 : 0);
        }
        if (this.typeId == 4) {
            return 66 + (this.haveTasks() ? 1 : 0);
        }
        return this.typeId * 2 + (this.haveTasks() ? 1 : 0) - 2;
    }

    @Override
    public boolean isEnabled() {
        if (!(this.module instanceof ModuleComputer) || ((ModuleComputer)this.module).getCurrentProg() == null) {
            return false;
        }
        if (this.haveTasks()) {
            for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
                if (task.getType() == this.typeId) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean haveTasks() {
        return ((ModuleComputer)this.module).getSelectedTasks().size() > 0;
    }

    @Override
    public void onServerClick(EntityPlayer player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
        if (this.haveTasks()) {
            for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
                task.setType(this.typeId);
            }
        } else {
            ComputerProg program = ((ModuleComputer)this.module).getCurrentProg();
            if (program != null) {
                ComputerTask task = new ComputerTask((ModuleComputer)this.module, program);
                task.setType(this.typeId);
                program.getTasks().add(task);
            }
        }
    }
}

