/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Config;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import net.moddedminecraft.mmcrestrict.Main;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class Config {
    private final Main plugin;
    private static ConfigurationLoader<CommentedConfigurationNode> loader;
    public static CommentedConfigurationNode config;
    public static boolean logToFile;
    public static List<String> sendToChestWhitelist;
    public static String defaultReason;
    public static Boolean defaultHidden;
    public static Boolean defaultUsage;
    public static Boolean defaultBreaking;
    public static Boolean defaultPlacing;
    public static Boolean defaultOwnership;
    public static Boolean defaultDrop;
    public static Boolean defaultCraft;
    public static Boolean defaultWorld;
    public static Boolean defaultAutoPurge;
    public static Integer defaultAutoPurgeInterval;
    public static Boolean notifyStaff;

    public Config(Main main) throws IOException, ObjectMappingException {
        this.plugin = main;
        loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.plugin.defaultConf)).build();
        config = (CommentedConfigurationNode)loader.load();
        this.configCheck();
    }

    public void configCheck() throws IOException, ObjectMappingException {
        if (!Files.exists(this.plugin.defaultConf, new LinkOption[0])) {
            Files.createFile(this.plugin.defaultConf, new FileAttribute[0]);
        }
        sendToChestWhitelist = config.getNode(new Object[]{"send-to-chest", "whitelist"}).hasListChildren() ? this.check(config.getNode(new Object[]{"send-to-chest", "whitelist"}), Collections.emptyList()).getList(TypeToken.of(String.class)) : config.getNode(new Object[]{"send-to-chest", "whitelist"}).setValue(Collections.emptyList()).getList(TypeToken.of(String.class));
        config.getNode(new Object[]{"defaults"}).setComment("Default values for any newly added banned item.");
        defaultReason = this.check(config.getNode(new Object[]{"defaults", "reason"}), defaultReason).getString();
        defaultHidden = this.check(config.getNode(new Object[]{"defaults", "hidden"}), defaultHidden).getBoolean();
        defaultUsage = this.check(config.getNode(new Object[]{"defaults", "usage"}), defaultUsage).getBoolean();
        defaultBreaking = this.check(config.getNode(new Object[]{"defaults", "breaking"}), defaultBreaking).getBoolean();
        defaultPlacing = this.check(config.getNode(new Object[]{"defaults", "placing"}), defaultPlacing).getBoolean();
        defaultOwnership = this.check(config.getNode(new Object[]{"defaults", "ownership"}), defaultOwnership).getBoolean();
        defaultDrop = this.check(config.getNode(new Object[]{"defaults", "drop"}), defaultDrop).getBoolean();
        defaultCraft = this.check(config.getNode(new Object[]{"defaults", "craft"}), defaultCraft).getBoolean();
        defaultWorld = this.check(config.getNode(new Object[]{"defaults", "world"}), defaultWorld).getBoolean();
        config.getNode(new Object[]{"world-auto-purge"}).setComment("Check all Loaded Chunks for banned items and remove them. If you experience lag, disable this and just use /restrict checkchunks manually");
        defaultAutoPurge = this.check(config.getNode(new Object[]{"world-auto-purge", "is-enabled"}), defaultAutoPurge).getBoolean();
        defaultAutoPurgeInterval = this.check(config.getNode(new Object[]{"world-auto-purge", "interval-in-minutes"}), defaultAutoPurgeInterval, "Check for banned items around the World... interval should be more than 5").getInt();
        if (defaultAutoPurgeInterval < 5) {
            defaultAutoPurgeInterval = 5;
        }
        notifyStaff = this.check(config.getNode(new Object[]{"notify-staff"}), notifyStaff, "If enabled, will notify staff if someone attempts to use a banned item.").getBoolean();
        logToFile = this.check(config.getNode(new Object[]{"log-to-file"}), true, "Log any banned action or banned item change to a file.").getBoolean();
        loader.save((ConfigurationNode)config);
    }

    private CommentedConfigurationNode check(CommentedConfigurationNode node, Object defaultValue, String comment) {
        if (node.isVirtual()) {
            node.setValue(defaultValue).setComment(comment);
        }
        return node;
    }

    private CommentedConfigurationNode check(CommentedConfigurationNode node, Object defaultValue) {
        if (node.isVirtual()) {
            node.setValue(defaultValue);
        }
        return node;
    }

    static {
        defaultReason = "";
        defaultHidden = false;
        defaultUsage = true;
        defaultBreaking = true;
        defaultPlacing = true;
        defaultOwnership = true;
        defaultDrop = false;
        defaultCraft = true;
        defaultWorld = false;
        defaultAutoPurge = false;
        defaultAutoPurgeInterval = 20;
        notifyStaff = true;
    }
}

