/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlayerSensor
extends MalisisBlock {
    public static PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static AxisAlignedBB AABB_SIDE = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.25, 0.125);
    private static AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.0625);

    public PlayerSensor() {
        super(Material.field_151594_q);
        this.setCreativeTab(MalisisBlocks.tab);
        this.setName("player_sensor");
        this.setTexture("malisisblocks:blocks/player_sensor");
        this.addComponent((IComponent)new DirectionalComponent(DirectionalComponent.ALL, DirectionalComponent.IPlacement.BLOCKSIDE));
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected List<IProperty<?>> getProperties() {
        return Lists.newArrayList((Object[])new IProperty[]{POWERED});
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION) {
            return null;
        }
        return DirectionalComponent.getDirection((IBlockState)state).func_176740_k() == EnumFacing.Axis.Y && world != null ? AABB_BOTTOM : AABB_SIDE;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        side = side.func_176734_d();
        return world.isSideSolid(pos.func_177972_a(side), side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.values()) {
            if (!world.isSideSolid(pos.func_177972_a(side), side)) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        EnumFacing dir = DirectionalComponent.getDirection((IBlockAccess)world, (BlockPos)pos).func_176734_d();
        if (!world.isSideSolid(pos.func_177972_a(dir), dir)) {
            this.func_176226_b(world, pos, this.func_176223_P(), 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (PlayerSensor.isPowered(state)) {
            this.notifyPower(world, pos, state);
        }
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return PlayerSensor.isPowered(state) ? 15 : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (PlayerSensor.isPowered(state) && DirectionalComponent.getDirection((IBlockAccess)world, (BlockPos)pos) == side) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_180497_b(pos, (Block)this, 5, 0);
    }

    public AxisAlignedBB getDetectionBox(IBlockAccess world, BlockPos pos) {
        EnumFacing dir = DirectionalComponent.getDirection((IBlockAccess)world, (BlockPos)pos);
        double x1 = pos.func_177958_n();
        double x2 = pos.func_177958_n();
        double z1 = pos.func_177952_p();
        double z2 = pos.func_177952_p();
        int yOffset = 1;
        int factor = -1;
        if (dir == EnumFacing.EAST) {
            x1 -= 1.0;
            x2 += 2.0;
            z2 += 1.0;
        } else if (dir == EnumFacing.WEST) {
            x1 -= 1.0;
            x2 += 2.0;
            z2 += 1.0;
        } else if (dir == EnumFacing.NORTH) {
            x2 += 1.0;
            z1 -= 1.0;
            z2 += 2.0;
        } else if (dir == EnumFacing.SOUTH) {
            x2 += 1.0;
            z1 -= 1.0;
            z2 += 2.0;
        } else if (dir == EnumFacing.UP) {
            x2 += 1.0;
            z2 += 1.0;
            factor = 1;
        } else if (dir == EnumFacing.DOWN) {
            x2 += 1.0;
            z2 += 1.0;
        }
        boolean isAir = world.func_175623_d(pos.func_177981_b(factor));
        while (isAir && yOffset < 6) {
            isAir = world.func_175623_d(pos.func_177981_b(factor * yOffset++));
        }
        return new AxisAlignedBB(x1, (double)pos.func_177956_o(), z1, x2, (double)pos.func_177981_b(factor * yOffset++).func_177956_o(), z2);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean gettingPowered;
        boolean powered = PlayerSensor.isPowered(state);
        if (world.field_72995_K) {
            return;
        }
        world.func_180497_b(pos, (Block)this, 5, 0);
        List list = world.func_72872_a(EntityPlayer.class, this.getDetectionBox((IBlockAccess)world, pos));
        boolean bl = gettingPowered = list != null && !list.isEmpty();
        if (powered != gettingPowered) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(gettingPowered)));
            this.notifyPower(world, pos, state);
        }
    }

    private void notifyPower(World world, BlockPos pos, IBlockState state) {
        world.func_175685_c(pos, (Block)this, true);
        world.func_175685_c(pos.func_177972_a(DirectionalComponent.getDirection((IBlockState)state).func_176734_d()), (Block)this, true);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static boolean isPowered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) + (PlayerSensor.isPowered(state) ? 8 : 0);
    }
}

