/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.calculator;

import java.util.ArrayList;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.calculator.PermissionCalculator;
import me.lucko.luckperms.common.calculator.processor.DirectProcessor;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import me.lucko.luckperms.common.calculator.processor.RegexProcessor;
import me.lucko.luckperms.common.calculator.processor.SpongeWildcardProcessor;
import me.lucko.luckperms.common.calculator.processor.WildcardProcessor;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.calculator.GroupDefaultsProcessor;
import me.lucko.luckperms.sponge.calculator.UserDefaultsProcessor;
import net.luckperms.api.query.QueryOptions;

public class SpongeCalculatorFactory
implements CalculatorFactory {
    private final LPSpongePlugin plugin;

    public SpongeCalculatorFactory(LPSpongePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public PermissionCalculator build(QueryOptions queryOptions, CacheMetadata metadata) {
        ArrayList<PermissionProcessor> processors = new ArrayList<PermissionProcessor>(6);
        processors.add(new DirectProcessor());
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_REGEX).booleanValue()) {
            processors.add(new RegexProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS).booleanValue()) {
            processors.add(new WildcardProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS_SPONGE).booleanValue()) {
            processors.add(new SpongeWildcardProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLY_SPONGE_DEFAULT_SUBJECTS).booleanValue()) {
            boolean overrideWildcards = this.plugin.getConfiguration().get(ConfigKeys.APPLY_DEFAULT_NEGATIONS_BEFORE_WILDCARDS);
            if (metadata.getHolderType() == HolderType.USER) {
                processors.add(new UserDefaultsProcessor(this.plugin.getService(), queryOptions, overrideWildcards));
            } else if (metadata.getHolderType() == HolderType.GROUP) {
                processors.add(new GroupDefaultsProcessor(this.plugin.getService(), queryOptions, overrideWildcards));
            }
        }
        return new PermissionCalculator(this.plugin, metadata, processors);
    }
}

