/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose.event;

import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import net.luckperms.api.query.QueryOptions;

public class MetaCheckEvent
extends VerboseEvent {
    private final Origin origin;
    private final String key;
    private final String result;

    public MetaCheckEvent(Origin origin, String checkTarget, QueryOptions checkQueryOptions, long checkTime, Throwable checkTrace, String checkThread, String key, String result) {
        super(checkTarget, checkQueryOptions, checkTime, checkTrace, checkThread);
        this.origin = origin;
        this.key = key;
        this.result = result;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getKey() {
        return this.key;
    }

    public String getResult() {
        return this.result;
    }

    @Override
    protected void serializeTo(JObject object) {
        object.add("type", "meta").add("key", this.key).add("result", this.result).add("origin", this.origin.name().toLowerCase());
    }

    @Override
    public boolean eval(String variable) {
        return variable.equals("meta") || this.getCheckTarget().equalsIgnoreCase(variable) || this.getKey().toLowerCase().startsWith(variable.toLowerCase()) || this.getResult().equalsIgnoreCase(variable);
    }

    public static enum Origin {
        PLATFORM_API,
        THIRD_PARTY_API,
        LUCKPERMS_API,
        INTERNAL;

    }
}

