/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.plugin.util;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.platform.Platform;

public abstract class AbstractConnectionListener {
    private final LuckPermsPlugin plugin;
    private final Set<UUID> uniqueConnections = ConcurrentHashMap.newKeySet();

    protected AbstractConnectionListener(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    public Set<UUID> getUniqueConnections() {
        return this.uniqueConnections;
    }

    protected void recordConnection(UUID uniqueId) {
        this.uniqueConnections.add(uniqueId);
    }

    public User loadUser(UUID uniqueId, String username) {
        User user;
        long startTime = System.currentTimeMillis();
        this.plugin.getUserManager().getHouseKeeper().registerUsage(uniqueId);
        PlayerSaveResult saveResult = this.plugin.getStorage().savePlayerData(uniqueId, username).join();
        if (saveResult.includes(PlayerSaveResult.Outcome.CLEAN_INSERT)) {
            this.plugin.getEventDispatcher().dispatchUserFirstLogin(uniqueId, username);
        }
        if (saveResult.includes(PlayerSaveResult.Outcome.OTHER_UNIQUE_IDS_PRESENT_FOR_USERNAME)) {
            Set<UUID> otherUuids = saveResult.getOtherUniqueIds();
            this.plugin.getLogger().warn("LuckPerms already has data for player '" + username + "' - but this data is stored under a different UUID.");
            this.plugin.getLogger().warn("'" + username + "' has previously used the unique ids " + otherUuids + " but is now connecting with '" + uniqueId + "'");
            if (uniqueId.version() == 4) {
                if (this.plugin.getBootstrap().getType() == Platform.Type.BUNGEECORD) {
                    this.plugin.getLogger().warn("The UUID the player is connecting with now is Mojang-assigned (type 4). This implies that BungeeCord's IP-Forwarding has not been setup correctly on one (or more) of the backend servers.");
                }
                if (this.plugin.getBootstrap().getType() == Platform.Type.VELOCITY) {
                    this.plugin.getLogger().warn("The UUID the player is connecting with now is Mojang-assigned (type 4). This implies that Velocity's IP-Forwarding has not been setup correctly on one (or more) of the backend servers.");
                } else {
                    this.plugin.getLogger().warn("The UUID the player is connecting with now is Mojang-assigned (type 4). This implies that one of the other servers in your network is not authenticating correctly.");
                    this.plugin.getLogger().warn("If you're using BungeeCord/Velocity, please ensure that IP-Forwarding is setup correctly on all of your backend servers!");
                }
            } else {
                this.plugin.getLogger().warn("The UUID the player is connecting with now is NOT Mojang-assigned (type " + uniqueId.version() + "). This implies that THIS server is not authenticating correctly, but one (or more) of the other servers/proxies in the network are.");
                this.plugin.getLogger().warn("If you're using BungeeCord/Velocity, please ensure that IP-Forwarding is setup correctly on all of your backend servers!");
            }
            this.plugin.getLogger().warn("See here for more info: https://luckperms.net/wiki/Network-Installation#pre-setup");
        }
        if ((user = this.plugin.getStorage().loadUser(uniqueId, username).join()) == null) {
            throw new NullPointerException("User is null");
        }
        long time = System.currentTimeMillis() - startTime;
        if (time >= 1000L) {
            this.plugin.getLogger().warn("Processing login for " + username + " took " + time + "ms.");
        }
        return user;
    }

    public void handleDisconnect(UUID uniqueId) {
        this.plugin.getUserManager().getHouseKeeper().registerUsage(uniqueId);
        this.plugin.getBootstrap().getScheduler().executeAsync(() -> {
            User user = (User)this.plugin.getUserManager().getIfLoaded(uniqueId);
            if (user != null) {
                user.clearNodes(DataType.TRANSIENT, null, false);
            }
        });
    }
}

