/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.lucko.luckperms.common.node.NodeEquality;
import me.lucko.luckperms.common.node.utils.ShorthandParser;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.ScopedNode;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.PermissionNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractNode<N extends ScopedNode<N, B>, B extends NodeBuilder<N, B>>
implements ScopedNode<N, B> {
    public static final char NODE_SEPARATOR = '.';
    public static final String NODE_SEPARATOR_STRING = String.valueOf('.');
    protected final String key;
    protected final boolean value;
    protected final long expireAt;
    protected final ImmutableContextSet contexts;
    protected final Map<NodeMetadataKey<?>, Object> metadata;
    private final List<String> resolvedShorthand;
    private final int hashCode;

    protected AbstractNode(String key, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        this.key = key;
        this.value = value;
        this.expireAt = expireAt;
        this.contexts = contexts;
        this.metadata = ImmutableMap.copyOf(metadata);
        this.resolvedShorthand = this instanceof PermissionNode ? ImmutableList.copyOf(ShorthandParser.expandShorthand(this.key)) : ImmutableList.of();
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public @NonNull String getKey() {
        return this.key;
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    @Override
    public @NonNull ImmutableContextSet getContexts() {
        return this.contexts;
    }

    @Override
    public <T> Optional<T> getMetadata(NodeMetadataKey<T> key) {
        Object value = this.metadata.get(key);
        return Optional.ofNullable(value);
    }

    @Override
    public boolean hasExpiry() {
        return this.expireAt != 0L;
    }

    @Override
    public @Nullable Instant getExpiry() {
        return this.hasExpiry() ? Instant.ofEpochSecond(this.expireAt) : null;
    }

    @Override
    public boolean hasExpired() {
        Instant expiry = this.getExpiry();
        return expiry != null && expiry.isBefore(Instant.now());
    }

    @Override
    public @Nullable Duration getExpiryDuration() {
        Instant expiry = this.getExpiry();
        if (expiry == null) {
            return null;
        }
        Instant now = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        return Duration.between(now, expiry);
    }

    @Override
    public @NonNull Collection<String> resolveShorthand() {
        return this.resolvedShorthand;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        return NodeEquality.KEY_VALUE_EXPIRY_CONTEXTS.equals(this, (AbstractNode)o);
    }

    @Override
    public boolean equals(@NonNull Node o, @NonNull NodeEqualityPredicate equalityPredicate) {
        AbstractNode other = (AbstractNode)o;
        NodeEquality nodeEquality = NodeEquality.of(equalityPredicate);
        if (nodeEquality != null) {
            return nodeEquality.equals(this, other);
        }
        return equalityPredicate.areEqual(this, o);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.key.hashCode();
        result = result * 59 + (this.value ? 79 : 97);
        result = result * 59 + (int)(this.expireAt >>> 32 ^ this.expireAt);
        result = result * 59 + this.contexts.hashCode();
        return result;
    }

    public String toString() {
        return "ImmutableNode(key=" + this.key + ", value=" + this.value + ", expireAt=" + this.expireAt + ", contexts=" + this.contexts + ")";
    }
}

