/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.DependencyDownloadException;
import me.lucko.luckperms.common.dependencies.DependencyRegistry;
import me.lucko.luckperms.common.dependencies.DependencyRepository;
import me.lucko.luckperms.common.dependencies.classloader.IsolatedClassLoader;
import me.lucko.luckperms.common.dependencies.relocation.Relocation;
import me.lucko.luckperms.common.dependencies.relocation.RelocationHandler;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.util.MoreFiles;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DependencyManager {
    private final LuckPermsPlugin plugin;
    private final DependencyRegistry registry;
    private final Path cacheDirectory;
    private final EnumMap<Dependency, Path> loaded = new EnumMap(Dependency.class);
    private final Map<ImmutableSet<Dependency>, IsolatedClassLoader> loaders = new HashMap<ImmutableSet<Dependency>, IsolatedClassLoader>();
    private @MonotonicNonNull RelocationHandler relocationHandler = null;

    public DependencyManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.registry = new DependencyRegistry(plugin);
        this.cacheDirectory = DependencyManager.setupCacheDirectory(plugin);
    }

    private synchronized RelocationHandler getRelocationHandler() {
        if (this.relocationHandler == null) {
            this.relocationHandler = new RelocationHandler(this);
        }
        return this.relocationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsolatedClassLoader obtainClassLoaderWith(Set<Dependency> dependencies) {
        ImmutableSet set = ImmutableSet.copyOf(dependencies);
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey((Object)dependency)) continue;
            throw new IllegalStateException("Dependency " + (Object)((Object)dependency) + " is not loaded.");
        }
        Map<ImmutableSet<Dependency>, IsolatedClassLoader> map = this.loaders;
        synchronized (map) {
            IsolatedClassLoader classLoader = this.loaders.get(set);
            if (classLoader != null) {
                return classLoader;
            }
            URL[] urls = (URL[])set.stream().map(this.loaded::get).map(file -> {
                try {
                    return file.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            classLoader = new IsolatedClassLoader(urls);
            this.loaders.put((ImmutableSet<Dependency>)set, classLoader);
            return classLoader;
        }
    }

    public void loadStorageDependencies(Set<StorageType> storageTypes) {
        this.loadDependencies(this.registry.resolveStorageDependencies(storageTypes));
    }

    public void loadDependencies(Set<Dependency> dependencies) {
        CountDownLatch latch = new CountDownLatch(dependencies.size());
        for (Dependency dependency : dependencies) {
            this.plugin.getBootstrap().getScheduler().async().execute(() -> {
                try {
                    this.loadDependency(dependency);
                }
                catch (Throwable e) {
                    this.plugin.getLogger().severe("Unable to load dependency " + dependency.name() + ".", e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void loadDependency(Dependency dependency) throws Exception {
        if (this.loaded.containsKey((Object)dependency)) {
            return;
        }
        Path file = this.remapDependency(dependency, this.downloadDependency(dependency));
        this.loaded.put(dependency, file);
        if (this.registry.shouldAutoLoad(dependency)) {
            this.plugin.getBootstrap().getClassPathAppender().addJarToClasspath(file);
        }
    }

    private Path downloadDependency(Dependency dependency) throws DependencyDownloadException {
        Path file = this.cacheDirectory.resolve(dependency.getFileName() + ".jar");
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        DependencyDownloadException lastError = null;
        for (DependencyRepository repo : DependencyRepository.values()) {
            try {
                repo.download(dependency, file);
                return file;
            }
            catch (DependencyDownloadException e) {
                lastError = e;
            }
        }
        throw (DependencyDownloadException)Objects.requireNonNull(lastError);
    }

    private Path remapDependency(Dependency dependency, Path normalFile) throws Exception {
        ArrayList<Relocation> rules = new ArrayList<Relocation>(dependency.getRelocations());
        this.registry.applyRelocationSettings(dependency, rules);
        if (rules.isEmpty()) {
            return normalFile;
        }
        Path remappedFile = this.cacheDirectory.resolve(dependency.getFileName() + "-remapped.jar");
        if (Files.exists(remappedFile, new LinkOption[0])) {
            return remappedFile;
        }
        this.getRelocationHandler().remap(normalFile, remappedFile, rules);
        return remappedFile;
    }

    private static Path setupCacheDirectory(LuckPermsPlugin plugin) {
        Path cacheDirectory = plugin.getBootstrap().getDataDirectory().resolve("libs");
        try {
            MoreFiles.createDirectoriesIfNotExists(cacheDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create libs directory", e);
        }
        Path oldCacheDirectory = plugin.getBootstrap().getDataDirectory().resolve("lib");
        if (Files.exists(oldCacheDirectory, new LinkOption[0])) {
            try {
                MoreFiles.deleteDirectory(oldCacheDirectory);
            }
            catch (IOException e) {
                plugin.getLogger().warn("Unable to delete lib directory", e);
            }
        }
        return cacheDirectory;
    }
}

