/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import me.lucko.luckperms.lib.adventure.key.Key;
import me.lucko.luckperms.lib.adventure.text.BlockNBTComponent;
import me.lucko.luckperms.lib.adventure.text.BlockNBTComponentImpl;
import me.lucko.luckperms.lib.adventure.text.ComponentBuilder;
import me.lucko.luckperms.lib.adventure.text.ComponentBuilderApplicable;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.EntityNBTComponent;
import me.lucko.luckperms.lib.adventure.text.EntityNBTComponentImpl;
import me.lucko.luckperms.lib.adventure.text.KeybindComponent;
import me.lucko.luckperms.lib.adventure.text.KeybindComponentImpl;
import me.lucko.luckperms.lib.adventure.text.PatternReplacementResult;
import me.lucko.luckperms.lib.adventure.text.ScoreComponent;
import me.lucko.luckperms.lib.adventure.text.ScoreComponentImpl;
import me.lucko.luckperms.lib.adventure.text.SelectorComponent;
import me.lucko.luckperms.lib.adventure.text.SelectorComponentImpl;
import me.lucko.luckperms.lib.adventure.text.StorageNBTComponent;
import me.lucko.luckperms.lib.adventure.text.StorageNBTComponentImpl;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.TextComponentImpl;
import me.lucko.luckperms.lib.adventure.text.TranslatableComponent;
import me.lucko.luckperms.lib.adventure.text.TranslatableComponentImpl;
import me.lucko.luckperms.lib.adventure.text.event.ClickEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEventSource;
import me.lucko.luckperms.lib.adventure.text.format.Style;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextDecoration;
import me.lucko.luckperms.lib.adventure.util.Buildable;
import me.lucko.luckperms.lib.adventure.util.IntFunction2;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Component
extends ComponentBuilderApplicable,
ComponentLike,
HoverEventSource<Component> {
    public static @NonNull TextComponent empty() {
        return TextComponentImpl.EMPTY;
    }

    public static @NonNull TextComponent newline() {
        return TextComponentImpl.NEWLINE;
    }

    public static @NonNull TextComponent space() {
        return TextComponentImpl.SPACE;
    }

    public static @NonNull TextComponent join(@NonNull ComponentLike separator, ComponentLike ... components) {
        return Component.join(separator, Arrays.asList(components));
    }

    public static @NonNull TextComponent join(@NonNull ComponentLike separator, Iterable<? extends ComponentLike> components) {
        Iterator<? extends ComponentLike> it = components.iterator();
        if (!it.hasNext()) {
            return Component.empty();
        }
        TextComponent.Builder builder = Component.text();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        return (TextComponent)builder.build();
    }

    public static @NonNull BlockNBTComponent.Builder blockNBT() {
        return new BlockNBTComponentImpl.BuilderImpl();
    }

    public static @NonNull BlockNBTComponent blockNBT(@NonNull Consumer<? super BlockNBTComponent.Builder> consumer) {
        return (BlockNBTComponent)Buildable.configureAndBuild(Component.blockNBT(), consumer);
    }

    public static @NonNull BlockNBTComponent blockNBT(@NonNull String nbtPath, @NonNull BlockNBTComponent.Pos pos) {
        return Component.blockNBT(nbtPath, false, pos);
    }

    public static @NonNull BlockNBTComponent blockNBT(@NonNull String nbtPath, boolean interpret, @NonNull BlockNBTComponent.Pos pos) {
        return new BlockNBTComponentImpl(Collections.emptyList(), Style.empty(), nbtPath, interpret, pos);
    }

    public static @NonNull EntityNBTComponent.Builder entityNBT() {
        return new EntityNBTComponentImpl.BuilderImpl();
    }

    public static @NonNull EntityNBTComponent entityNBT(@NonNull Consumer<? super EntityNBTComponent.Builder> consumer) {
        return (EntityNBTComponent)Buildable.configureAndBuild(Component.entityNBT(), consumer);
    }

    public static @NonNull EntityNBTComponent entityNBT(@NonNull String nbtPath, @NonNull String selector) {
        return (EntityNBTComponent)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath(nbtPath)).selector(selector).build();
    }

    public static @NonNull KeybindComponent.Builder keybind() {
        return new KeybindComponentImpl.BuilderImpl();
    }

    public static @NonNull KeybindComponent keybind(@NonNull Consumer<? super KeybindComponent.Builder> consumer) {
        return (KeybindComponent)Buildable.configureAndBuild(Component.keybind(), consumer);
    }

    public static @NonNull KeybindComponent keybind(@NonNull String keybind) {
        return Component.keybind(keybind, Style.empty());
    }

    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @NonNull Style style) {
        return new KeybindComponentImpl(Collections.emptyList(), style, keybind);
    }

    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @Nullable TextColor color) {
        return Component.keybind(keybind, Style.style(color));
    }

    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.keybind(keybind, Style.style(color, decorations));
    }

    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.keybind(keybind, Style.style(color, decorations));
    }

    public static @NonNull ScoreComponent.Builder score() {
        return new ScoreComponentImpl.BuilderImpl();
    }

    public static @NonNull ScoreComponent score(@NonNull Consumer<? super ScoreComponent.Builder> consumer) {
        return (ScoreComponent)Buildable.configureAndBuild(Component.score(), consumer);
    }

    public static @NonNull ScoreComponent score(@NonNull String name, @NonNull String objective) {
        return Component.score(name, objective, null);
    }

    public static @NonNull ScoreComponent score(@NonNull String name, @NonNull String objective, @Nullable String value) {
        return new ScoreComponentImpl(Collections.emptyList(), Style.empty(), name, objective, value);
    }

    public static @NonNull SelectorComponent.Builder selector() {
        return new SelectorComponentImpl.BuilderImpl();
    }

    public static @NonNull SelectorComponent selector(@NonNull Consumer<? super SelectorComponent.Builder> consumer) {
        return (SelectorComponent)Buildable.configureAndBuild(Component.selector(), consumer);
    }

    public static @NonNull SelectorComponent selector(@NonNull String pattern) {
        return new SelectorComponentImpl(Collections.emptyList(), Style.empty(), pattern);
    }

    public static @NonNull StorageNBTComponent.Builder storageNBT() {
        return new StorageNBTComponentImpl.BuilderImpl();
    }

    public static @NonNull StorageNBTComponent storageNBT(@NonNull Consumer<? super StorageNBTComponent.Builder> consumer) {
        return (StorageNBTComponent)Buildable.configureAndBuild(Component.storageNBT(), consumer);
    }

    public static @NonNull StorageNBTComponent storageNBT(@NonNull String nbtPath, @NonNull Key storage) {
        return Component.storageNBT(nbtPath, false, storage);
    }

    public static @NonNull StorageNBTComponent storageNBT(@NonNull String nbtPath, boolean interpret, @NonNull Key storage) {
        return new StorageNBTComponentImpl(Collections.emptyList(), Style.empty(), nbtPath, interpret, storage);
    }

    public static @NonNull TextComponent.Builder text() {
        return new TextComponentImpl.BuilderImpl();
    }

    public static @NonNull TextComponent text(@NonNull Consumer<? super TextComponent.Builder> consumer) {
        return (TextComponent)Buildable.configureAndBuild(Component.text(), consumer);
    }

    public static @NonNull TextComponent text(@NonNull String content) {
        if (content.isEmpty()) {
            return Component.empty();
        }
        return new TextComponentImpl(Collections.emptyList(), Style.empty(), content);
    }

    public static @NonNull TextComponent text(@NonNull String content, @NonNull Style style) {
        return new TextComponentImpl(Collections.emptyList(), style, content);
    }

    public static @NonNull TextComponent text(@NonNull String content, @Nullable TextColor color) {
        return new TextComponentImpl(Collections.emptyList(), Style.style(color), content);
    }

    public static @NonNull TextComponent text(@NonNull String content, @Nullable TextColor color, TextDecoration ... decorations) {
        return new TextComponentImpl(Collections.emptyList(), Style.style(color, decorations), content);
    }

    public static @NonNull TextComponent text(@NonNull String content, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return new TextComponentImpl(Collections.emptyList(), Style.style(color, decorations), content);
    }

    public static @NonNull TextComponent text(boolean value) {
        return Component.text(String.valueOf(value));
    }

    public static @NonNull TextComponent text(boolean value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    public static @NonNull TextComponent text(boolean value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    public static @NonNull TextComponent text(boolean value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(boolean value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(char value) {
        if (value == '\n') {
            return Component.newline();
        }
        if (value == ' ') {
            return Component.space();
        }
        return Component.text(String.valueOf(value));
    }

    public static @NonNull TextComponent text(char value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    public static @NonNull TextComponent text(char value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    public static @NonNull TextComponent text(char value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(char value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(double value) {
        return Component.text(String.valueOf(value));
    }

    public static @NonNull TextComponent text(double value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    public static @NonNull TextComponent text(double value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    public static @NonNull TextComponent text(double value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(double value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(float value) {
        return Component.text(String.valueOf(value));
    }

    public static @NonNull TextComponent text(float value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    public static @NonNull TextComponent text(float value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    public static @NonNull TextComponent text(float value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(float value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(int value) {
        return Component.text(String.valueOf(value));
    }

    public static @NonNull TextComponent text(int value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    public static @NonNull TextComponent text(int value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    public static @NonNull TextComponent text(int value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(int value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(long value) {
        return Component.text(String.valueOf(value));
    }

    public static @NonNull TextComponent text(long value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    public static @NonNull TextComponent text(long value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    public static @NonNull TextComponent text(long value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TextComponent text(long value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    public static @NonNull TranslatableComponent.Builder translatable() {
        return new TranslatableComponentImpl.BuilderImpl();
    }

    public static @NonNull TranslatableComponent translatable(@NonNull Consumer<? super TranslatableComponent.Builder> consumer) {
        return (TranslatableComponent)Buildable.configureAndBuild(Component.translatable(), consumer);
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key) {
        return Component.translatable(key, Style.empty());
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull Style style) {
        return new TranslatableComponentImpl(Collections.emptyList(), style, key, Collections.emptyList());
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color) {
        return Component.translatable(key, Style.style(color));
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.translatable(key, Style.style(color, decorations));
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.translatable(key, Style.style(color, decorations));
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, ComponentLike ... args) {
        return Component.translatable(key, Style.empty(), args);
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull Style style, ComponentLike ... args) {
        return new TranslatableComponentImpl(Collections.emptyList(), style, key, args);
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, ComponentLike ... args) {
        return Component.translatable(key, Style.style(color), args);
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, ComponentLike ... args) {
        return Component.translatable(key, Style.style(color, decorations), args);
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull List<? extends ComponentLike> args) {
        return new TranslatableComponentImpl(Collections.emptyList(), Style.empty(), key, args);
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull Style style, @NonNull List<? extends ComponentLike> args) {
        return new TranslatableComponentImpl(Collections.emptyList(), style, key, args);
    }

    public static TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull List<? extends ComponentLike> args) {
        return Component.translatable(key, Style.style(color), args);
    }

    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, @NonNull List<? extends ComponentLike> args) {
        return Component.translatable(key, Style.style(color, decorations), args);
    }

    public @NonNull List<Component> children();

    public @NonNull Component children(@NonNull List<? extends ComponentLike> var1);

    default public boolean contains(@NonNull Component that) {
        if (this == that) {
            return true;
        }
        for (Component child : this.children()) {
            if (!child.contains(that)) continue;
            return true;
        }
        HoverEvent<?> hoverEvent = this.hoverEvent();
        if (hoverEvent != null && hoverEvent.action().type().isAssignableFrom(Component.class)) {
            Component hover = (Component)hoverEvent.value();
            if (that == hover) {
                return true;
            }
            for (Component child : hover.children()) {
                if (!child.contains(that)) continue;
                return true;
            }
        }
        return false;
    }

    default public void detectCycle(@NonNull Component that) {
        if (that.contains(this)) {
            throw new IllegalStateException("Component cycle detected between " + this + " and " + that);
        }
    }

    public @NonNull Component append(@NonNull Component var1);

    default public @NonNull Component append(@NonNull ComponentLike component) {
        return this.append(component.asComponent());
    }

    default public @NonNull Component append(@NonNull ComponentBuilder<?, ?> builder) {
        return this.append((Component)builder.build());
    }

    public @NonNull Style style();

    public @NonNull Component style(@NonNull Style var1);

    default public @NonNull Component style(@NonNull Consumer<Style.Builder> consumer) {
        return this.style(this.style().edit(consumer));
    }

    default public @NonNull Component style(@NonNull Consumer<Style.Builder> consumer, @NonNull Style.Merge.Strategy strategy) {
        return this.style(this.style().edit(consumer, strategy));
    }

    default public @NonNull Component style(@NonNull Style.Builder style) {
        return this.style(style.build());
    }

    default public @NonNull Component mergeStyle(@NonNull Component that) {
        return this.mergeStyle(that, Style.Merge.all());
    }

    default public @NonNull Component mergeStyle(@NonNull Component that, Style.Merge ... merges) {
        return this.mergeStyle(that, Style.Merge.of(merges));
    }

    default public @NonNull Component mergeStyle(@NonNull Component that, @NonNull Set<Style.Merge> merges) {
        return this.style(this.style().merge(that.style(), merges));
    }

    default public @Nullable TextColor color() {
        return this.style().color();
    }

    default public @NonNull Component color(@Nullable TextColor color) {
        return this.style(this.style().color(color));
    }

    default public @NonNull Component colorIfAbsent(@Nullable TextColor color) {
        if (this.color() == null) {
            return this.color(color);
        }
        return this;
    }

    default public boolean hasDecoration(@NonNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    default public @NonNull Component decorate(@NonNull TextDecoration decoration) {
        return this.decoration(decoration, TextDecoration.State.TRUE);
    }

    default public @NonNull TextDecoration.State decoration(@NonNull TextDecoration decoration) {
        return this.style().decoration(decoration);
    }

    default public @NonNull Component decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    default public @NonNull Component decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        return this.style(this.style().decoration(decoration, state));
    }

    default public @NonNull Map<TextDecoration, TextDecoration.State> decorations() {
        return this.style().decorations();
    }

    default public @NonNull Component decorations(@NonNull Map<TextDecoration, TextDecoration.State> decorations) {
        return this.style(this.style().decorations(decorations));
    }

    default public @Nullable ClickEvent clickEvent() {
        return this.style().clickEvent();
    }

    default public @NonNull Component clickEvent(@Nullable ClickEvent event) {
        return this.style(this.style().clickEvent(event));
    }

    default public @Nullable HoverEvent<?> hoverEvent() {
        return this.style().hoverEvent();
    }

    default public @NonNull Component hoverEvent(@Nullable HoverEventSource<?> source) {
        HoverEvent<?> event = HoverEventSource.unbox(source);
        if (event != null && event.action().type().isAssignableFrom(Component.class)) {
            this.detectCycle((Component)event.value());
        }
        return this.style(this.style().hoverEvent(event));
    }

    default public @Nullable String insertion() {
        return this.style().insertion();
    }

    default public @NonNull Component insertion(@Nullable String insertion) {
        return this.style(this.style().insertion(insertion));
    }

    default public boolean hasStyling() {
        return !this.style().isEmpty();
    }

    default public @NonNull Component replaceText(@NonNull String search, @Nullable ComponentLike replacement) {
        return this.replaceText(Pattern.compile(search, 16), (TextComponent.Builder old) -> replacement);
    }

    default public @NonNull Component replaceText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement) {
        return this.replaceText(pattern, replacement, (int index, int replaced) -> PatternReplacementResult.REPLACE);
    }

    default public @NonNull Component replaceFirstText(@NonNull String search, @Nullable ComponentLike replacement) {
        return this.replaceText(search, replacement, 1);
    }

    default public @NonNull Component replaceFirstText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement) {
        return this.replaceText(pattern, replacement, 1);
    }

    default public @NonNull Component replaceText(@NonNull String search, @Nullable ComponentLike replacement, int numberOfReplacements) {
        return this.replaceText(search, replacement, (int index, int replaced) -> replaced < numberOfReplacements ? PatternReplacementResult.REPLACE : PatternReplacementResult.STOP);
    }

    default public @NonNull Component replaceText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement, int numberOfReplacements) {
        return this.replaceText(pattern, replacement, (int index, int replaced) -> replaced < numberOfReplacements ? PatternReplacementResult.REPLACE : PatternReplacementResult.STOP);
    }

    default public @NonNull Component replaceText(@NonNull String search, @Nullable ComponentLike replacement, @NonNull IntFunction2<PatternReplacementResult> fn) {
        return this.replaceText(Pattern.compile(search, 16), (TextComponent.Builder old) -> replacement, fn);
    }

    public @NonNull Component replaceText(@NonNull Pattern var1, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> var2, @NonNull IntFunction2<PatternReplacementResult> var3);

    @Override
    default public void componentBuilderApply(@NonNull ComponentBuilder<?, ?> component) {
        component.append(this);
    }

    @Override
    default public @NonNull Component asComponent() {
        return this;
    }

    @Override
    default public @NonNull HoverEvent<Component> asHoverEvent(@NonNull UnaryOperator<Component> op) {
        return HoverEvent.showText((Component)op.apply(this));
    }
}

