/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.entities;

import asmodeuscore.api.entity.ICustomEngine;
import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.handler.capabilities.ACStatsCapability;
import asmodeuscore.core.handler.capabilities.IStatsCapability;
import galaxyspace.GalaxySpace;
import galaxyspace.core.GSBlocks;
import galaxyspace.core.GSItems;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockAdvancedLandingPadFull;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class EntityTier6Rocket
extends EntityTieredRocket
implements ICustomEngine {
    private SpaceData.Engine_Type engine_type = SpaceData.Engine_Type.FUEL_ENGINE;
    private boolean waitFormMultiPlayer;
    static Field marsConfigAllDimsAllowed;

    public EntityTier6Rocket(World par1World) {
        super(par1World);
        this.func_70105_a(2.2f, 11.0f);
    }

    public EntityTier6Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public EntityTier6Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType, SpaceData.Engine_Type engine) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.engine_type = engine;
    }

    public EntityTier6Rocket(World par1World, double par2, double par4, double par6, boolean reversed, IRocketType.EnumRocketType rocketType, NonNullList<ItemStack> inv) {
        this(par1World, par2, par4, par6, rocketType);
        this.stacks = inv;
    }

    public double func_70033_W() {
        return 1.4f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(GSItems.ROCKET_TIER_6, 1, this.rocketType.getIndex());
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.getMountedYOffset(passenger) + passenger.func_70033_W(), this.field_70161_v);
        }
    }

    public double getMountedYOffset(Entity passenger) {
        if (this.func_184188_bt().size() > 1) {
            if (((Entity)this.func_184188_bt().get(0)).equals((Object)passenger)) {
                return 5.0;
            }
            return 1.75;
        }
        return 2.75;
    }

    public void igniteCheckingCooldown() {
        super.igniteCheckingCooldown();
    }

    @Deprecated
    public double func_70042_X() {
        return 2.75;
    }

    public float getRotateOffset() {
        return 1.25f;
    }

    public double getOnPadYOffset() {
        return 0.0;
    }

    public void onLaunch() {
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            GCPlayerStats stats = null;
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity player : this.func_184188_bt()) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    stats = GCPlayerStats.get((Entity)player);
                    stats.setLaunchpadStack(null);
                    if (this.field_70170_p.field_73011_w instanceof IOrbitDimension) continue;
                    stats.setCoordsTeleportedFromX(player.field_70165_t);
                    stats.setCoordsTeleportedFromZ(player.field_70161_v);
                }
                Entity playerMain = (Entity)this.func_184188_bt().get(0);
                if (playerMain instanceof EntityPlayerMP) {
                    stats = GCPlayerStats.get((Entity)playerMain);
                }
            }
            int amountRemoved = 0;
            block1: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 2; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 2; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 2; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 2; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == null || !(block instanceof BlockAdvancedLandingPadFull) || amountRemoved >= 25) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, pos);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block1;
                        this.field_70170_p.func_175698_g(pos);
                        amountRemoved = 25;
                        break block1;
                    }
                }
            }
            if (stats != null && amountRemoved == 25) {
                stats.setLaunchpadStack(new ItemStack(GSBlocks.ADVANCED_LANDING_PAD_SINGLE, 25, 0));
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public void func_70071_h_() {
        if (this.getWaitForMultiPlayer()) {
            if (!this.func_184188_bt().isEmpty()) {
                Entity passenger = (Entity)this.func_184188_bt().get(0);
                Entity passenger2 = null;
                if (this.func_184188_bt().size() > 1) {
                    passenger2 = (Entity)this.func_184188_bt().get(1);
                }
                if (this.ticks >= 40L) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184226_ay();
                        passenger.func_184205_a((Entity)this, true);
                        if (passenger2 != null) {
                            passenger2.func_184205_a((Entity)this, true);
                        }
                        GCLog.debug((String)"Remounting player in rocket.");
                    }
                    this.setWaitForPlayer(false);
                    this.field_70181_x = -0.5;
                } else {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    passenger.field_70179_y = 0.0;
                    passenger.field_70181_x = 0.0;
                    passenger.field_70159_w = 0.0;
                    if (passenger2 != null) {
                        passenger2.field_70179_y = 0.0;
                        passenger2.field_70181_x = 0.0;
                        passenger2.field_70159_w = 0.0;
                    }
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.hasValidFuel() && this.field_70146_Z.nextInt(4) == 0 && !this.getLaunched() && this.getEngine() == SpaceData.Engine_Type.FUEL_ENGINE) {
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t + 0.4 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble()), new Vector3(0.11, -0.5, -0.03), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.8 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble()), new Vector3(-0.2, -0.5, -0.03), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + 0.4 + this.field_70146_Z.nextDouble()), new Vector3(0.0, -0.5, 0.16), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v - 0.4 + this.field_70146_Z.nextDouble()), new Vector3(0.0, -0.5, -0.16), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                double d = this.timeSinceLaunch / 150.0f;
                int mod_engine = 1;
                if (this.engine_type == SpaceData.Engine_Type.SUBLIGHT_ENGINE) {
                    mod_engine = 5;
                }
                if ((d = this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).hasNoAtmosphere() ? Math.min(d * 1.2 * (double)mod_engine, (double)(2 * mod_engine)) : Math.min(d * (double)mod_engine, 1.4 * (double)mod_engine)) != 0.0) {
                    this.field_70181_x = -d * 2.5 * (double)mod_engine * Math.cos((this.field_70125_A - 180.0f) / 57.295776f);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(4);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase != null) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
            if (this.stacks == null || this.stacks.isEmpty()) {
                stats.setRocketStacks(NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a));
            } else {
                stats.setRocketStacks(this.stacks);
            }
            stats.setRocketType(this.rocketType.getIndex());
            stats.setFuelLevel(this.fuelTank.getFluidAmount());
            if (this.engine_type == SpaceData.Engine_Type.SUBLIGHT_ENGINE) {
                ItemStack withengine = new ItemStack(GSItems.ROCKET_TIER_6, 1, this.rocketType.getIndex());
                if (!withengine.func_77942_o()) {
                    withengine.func_77982_d(new NBTTagCompound());
                }
                withengine.func_77978_p().func_74757_a(SpaceData.Engine_Type.SUBLIGHT_ENGINE.getName(), true);
                withengine.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, 0);
                for (int i = 0; i < stats.getRocketStacks().size(); ++i) {
                    if (i != stats.getRocketStacks().size() - 1) continue;
                    stats.getRocketStacks().set(i, (Object)withengine);
                    break;
                }
            } else {
                stats.setRocketItem(GSItems.ROCKET_TIER_6);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onReachAtmosphere() {
        block17: {
            block18: {
                block19: {
                    if (this.destinationFrequency == -1) break block17;
                    if (this.field_70170_p.field_72995_K) {
                        this.stopRocketSound();
                        return;
                    }
                    this.setTarget(true, this.destinationFrequency);
                    if (this.targetVec == null) break block18;
                    if (this.targetDimension == this.field_70170_p.field_73011_w.getDimension()) break block19;
                    WorldProvider targetDim = WorldUtil.getProviderForDimensionServer((int)this.targetDimension);
                    if (targetDim != null && targetDim.field_76579_a instanceof WorldServer) {
                        boolean dimensionAllowed;
                        boolean bl = dimensionAllowed = this.targetDimension == ConfigManagerCore.idDimensionOverworld;
                        if (targetDim instanceof IGalacticraftWorldProvider) {
                            dimensionAllowed = ((IGalacticraftWorldProvider)targetDim).canSpaceshipTierPass(this.getRocketTier());
                        } else if ((this.targetDimension > 1 || this.targetDimension < -1) && marsConfigAllDimsAllowed != null) {
                            try {
                                if (marsConfigAllDimsAllowed.getBoolean(null)) {
                                    dimensionAllowed = true;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (dimensionAllowed) {
                            if (!this.func_184188_bt().isEmpty()) {
                                Iterator e = this.func_184188_bt().iterator();
                                while (e.hasNext()) {
                                    Entity passenger = (Entity)e.next();
                                    if (!(passenger instanceof EntityPlayerMP)) continue;
                                    WorldUtil.transferEntityToDimension((Entity)passenger, (int)this.targetDimension, (WorldServer)((WorldServer)targetDim.field_76579_a), (boolean)false, (EntityAutoRocket)this);
                                }
                                return;
                            }
                            Entity e = WorldUtil.transferEntityToDimension((Entity)this, (int)this.targetDimension, (WorldServer)((WorldServer)targetDim.field_76579_a), (boolean)false, null);
                            if (e instanceof EntityAutoRocket) {
                                e.func_70107_b((double)((float)this.targetVec.func_177958_n() + 0.5f), (double)(this.targetVec.func_177956_o() + 800), (double)((float)this.targetVec.func_177952_p() + 0.5f));
                                ((EntityAutoRocket)e).setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
                                ((EntityAutoRocket)e).setWaitForPlayer(false);
                                return;
                            }
                            GCLog.info((String)"Error: failed to recreate the unmanned rocket in landing mode on target planet.");
                            e.func_70106_y();
                            this.func_70106_y();
                            return;
                        }
                    }
                    break block17;
                }
                this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.1;
                Iterator iterator = this.func_184188_bt().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
                        return;
                    }
                    Entity passenger = (Entity)iterator.next();
                    if (!(passenger instanceof EntityPlayerMP)) continue;
                    WorldUtil.forceMoveEntityToPos((Entity)passenger, (WorldServer)((WorldServer)this.field_70170_p), (Vector3)new Vector3((double)((float)this.targetVec.func_177958_n() + 0.5f), (double)(this.targetVec.func_177956_o() + 800), (double)((float)this.targetVec.func_177952_p() + 0.5f)), (boolean)false);
                    this.setWaitForPlayer(true);
                    GCLog.debug((String)"Rocket repositioned, waiting for player");
                }
            }
            GCLog.info((String)"Error: the launch controlled rocket failed to find a valid landing spot when it reached space.");
            this.fuelTank.drain(Integer.MAX_VALUE, true);
            this.field_70163_u = Math.max(255.0, (this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0) - 200.0);
            return;
        }
        if (this.field_70170_p.field_72995_K) return;
        Iterator iterator = this.func_184188_bt().iterator();
        while (true) {
            Entity secondPassenger;
            if (!iterator.hasNext()) {
                this.func_70106_y();
                return;
            }
            Entity e = (Entity)iterator.next();
            if (!(e instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)e;
            this.onTeleport(player);
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            if (this.func_184188_bt().size() > 1 && (secondPassenger = (Entity)this.func_184188_bt().get(1)) instanceof EntityPlayerMP) {
                IStatsCapability acstats = ACStatsCapability.get((Entity)((EntityPlayerMP)secondPassenger));
                acstats.setSecondPassenger(true);
            }
            WorldUtil.toCelestialSelection((EntityPlayerMP)player, (GCPlayerStats)stats, (int)this.getRocketTier());
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            return false;
        }
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().contains(player)) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, this.field_70170_p.field_73011_w.getDimension(), new Object[0]), (EntityPlayerMP)player);
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                stats.setChatCooldown(0);
                float heightBefore = this.field_70131_O;
                this.field_70131_O /= 2.0f;
                this.func_184226_ay();
                this.field_70131_O = heightBefore;
            }
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_DISPLAY_ROCKET_CONTROLS, this.field_70170_p.field_73011_w.getDimension(), new Object[0]), (EntityPlayerMP)player);
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                stats.setChatCooldown(0);
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean getWaitForPlayer() {
        return super.getWaitForPlayer();
    }

    public void setWaitForPlayer(boolean waitForPlayer) {
        super.setWaitForPlayer(waitForPlayer);
        this.waitFormMultiPlayer = waitForPlayer;
    }

    public boolean getWaitForMultiPlayer() {
        return this.waitFormMultiPlayer;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 1;
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.func_177956_o();
                modifier = Math.max(modifier, 180.0);
                x1 *= modifier / 200.0;
                y1 *= Math.min(modifier / 200.0, 2.5);
                z1 *= modifier / 200.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - 0.75 * this.field_70181_x - 0.3 + 2.5;
            double x2 = this.field_70165_t + x1 + this.field_70159_w;
            double z2 = this.field_70161_v + z1 + this.field_70179_y;
            Vector3 motionVec = new Vector3(x1 + this.field_70159_w, y1 + this.field_70181_x, z1 + this.field_70179_y);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched());
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched());
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched());
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched());
            this.makeFlame(x2, y2, z2, new Vector3(x1, y1, z1), this.getLaunched());
        }
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched) {
        EntityLivingBase riddenByEntity;
        EntityLivingBase entityLivingBase = riddenByEntity = this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityLivingBase) ? null : (EntityLivingBase)this.func_184188_bt().get(0);
        if (getLaunched) {
            if (this.engine_type == SpaceData.Engine_Type.FUEL_ENGINE) {
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, new Object[]{riddenByEntity});
            }
            if (this.engine_type == SpaceData.Engine_Type.ION_ENGINE) {
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
                GalaxySpace.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, new Object[]{riddenByEntity, new Vector3(0.0, 252.0, 251.0)});
            }
            return;
        }
        if (this.field_70173_aa % 2 == 0) {
            return;
        }
        y2 += 1.6;
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        if (this.engine_type == SpaceData.Engine_Type.FUEL_ENGINE) {
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.3, y1 - 0.3, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.3, y1 - 0.3, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.3), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.3), new Object[]{riddenByEntity});
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return !this.field_70128_L && par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    public void getNetworkedData(ArrayList<Object> list) {
        super.getNetworkedData(list);
    }

    public void decodePacketdata(ByteBuf buffer) {
        super.decodePacketdata(buffer);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("engine_type", this.engine_type.getID());
        nbt.func_74757_a("WaitingForMultiPlayer", this.getWaitForMultiPlayer());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.engine_type = SpaceData.Engine_Type.byID((int)nbt.func_74762_e("engine_type"));
        this.setWaitForPlayer(nbt.func_74767_n("WaitingForMultiPlayer"));
    }

    public int getRocketTier() {
        return 6;
    }

    public int getFuelTankCapacity() {
        return 4500;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = new ItemStack(GSItems.ROCKET_TIER_6, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    public float getRenderOffsetY() {
        return -0.2f;
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityAdvLandingPad;
    }

    public int addFuel(FluidStack liquid, boolean doFill) {
        return GSUtils.fillWithGCFuel(this.fuelTank, liquid, doFill, this);
    }

    public void setEngine(SpaceData.Engine_Type type) {
        this.engine_type = type;
    }

    public SpaceData.Engine_Type getEngine() {
        return this.engine_type;
    }

    static {
        try {
            Class<?> marsConfig = Class.forName("micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars");
            marsConfigAllDimsAllowed = marsConfig.getField("launchControllerAllDims");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

