/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.render.entity.layers;

import galaxyspace.core.GSItems;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemThermalPaddingBase;
import micdoodle8.mods.galacticraft.api.item.IItemThermal;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.model.ModelPlayerGC;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerThermalPadding
extends LayerArmorBase<ModelBiped> {
    private final RenderPlayer renderer;
    private final ResourceLocation texture_t3 = new ResourceLocation("galaxyspace", "textures/model/armor/thermal_padding_t3_1.png");
    private final ResourceLocation texture_t4 = new ResourceLocation("galaxyspace", "textures/model/armor/thermal_padding_t4_1.png");

    public LayerThermalPadding(RenderPlayer playerRendererIn) {
        super((RenderLivingBase)playerRendererIn);
        this.renderer = playerRendererIn;
    }

    public boolean func_177142_b() {
        return false;
    }

    protected void setModelSlotVisible(ModelBiped model, EntityEquipmentSlot slotIn) {
        model.func_178719_a(false);
        switch (slotIn) {
            case HEAD: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case CHEST: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case LEGS: {
                model.field_78115_e.field_78806_j = true;
                model.field_178723_h.field_78806_j = true;
                model.field_178724_i.field_78806_j = true;
                break;
            }
            case FEET: {
                model.field_78116_c.field_78806_j = true;
                model.field_178720_f.field_78806_j = true;
            }
        }
    }

    public ItemStack getItemStackFromSlot(EntityLivingBase living, EntityEquipmentSlot slotIn) {
        int padding;
        PlayerGearData gearData = GalacticraftCore.proxy.getGearData((EntityPlayer)living);
        if (gearData != null && (padding = gearData.getThermalPadding(slotIn.func_188452_c() - 1)) != -1) {
            switch (padding) {
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    return new ItemStack(GSItems.THERMAL_PADDING_3, 1, slotIn.func_188452_c() - 1);
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    return new ItemStack(GSItems.THERMAL_PADDING_4, 1, slotIn.func_188452_c() - 1);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
    }

    private void renderArmorLayer(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
        ItemStack itemstack = this.getItemStackFromSlot(entityLivingBaseIn, slotIn);
        if (!itemstack.func_190926_b()) {
            ModelBiped model = this.getModelFromSlot(slotIn);
            model.func_178686_a((ModelBase)this.renderer.func_177087_b());
            model.func_78086_a(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.setModelSlotVisible(model, slotIn);
            if (itemstack.func_77973_b() instanceof ItemThermalPaddingBase) {
                IItemThermal item = (IItemThermal)itemstack.func_77973_b();
                switch (item.getThermalStrength()) {
                    case 3: {
                        this.renderer.func_110776_a(this.texture_t3);
                        break;
                    }
                    case 4: {
                        this.renderer.func_110776_a(this.texture_t4);
                    }
                }
            }
            model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179140_f();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderPlayerGC.thermalPaddingTexture0);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            float time = (float)entityLivingBaseIn.field_70173_aa / 10.0f;
            float sTime = (float)Math.sin(time) * 0.5f + 0.5f;
            float r = 0.2f * sTime;
            float g = 1.0f * sTime;
            float b = 0.2f * sTime;
            if (entityLivingBaseIn.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
                float modifier = ((IGalacticraftWorldProvider)entityLivingBaseIn.field_70170_p.field_73011_w).getThermalLevelModifier();
                if (modifier > 0.0f) {
                    b = g;
                    g = r;
                } else if (modifier < 0.0f) {
                    r = g;
                    g = b;
                }
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)(0.4f * sTime));
            model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
        }
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelPlayerGC(0.55f, false);
        this.field_177186_d = new ModelPlayerGC(0.05f, false);
    }

    public ModelBiped getModelFromSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.FEET ? (ModelBiped)this.field_177189_c : (ModelBiped)this.field_177186_d;
    }
}

