/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.storage.util;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public class KeyedObject<K, O> {
    private final K key;
    @Nullable
    private final O value;

    public KeyedObject(K key, @Nullable O value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public Optional<O> getValue() {
        return Optional.ofNullable(this.value);
    }

    public <R> KeyedObject<K, R> mapValue(Function<O, R> mapper) {
        return new KeyedObject<K, Object>(this.key, (this.value != null ? (O)mapper.apply(this.value) : null));
    }
}

