/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.holders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleHolder;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleMetadata;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleDiscoveryException;
import java.util.Map;
import java.util.Set;

public final class ProvidedModuleHolder<M extends Module, D extends M>
extends ModuleHolder<M, D> {
    private final Map<Class<? extends M>, M> moduleMap;

    public static <M extends Module, D extends M> Builder<M, D> builder(Class<M> moduleClass, Class<D> disableClass) {
        return new Builder<M, D>(moduleClass, disableClass);
    }

    private ProvidedModuleHolder(Builder<M, D> builder) throws QuickStartModuleDiscoveryException {
        super(builder);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Module module : ((Builder)builder).modules) {
            mapBuilder.put(module.getClass(), (Object)module);
        }
        this.moduleMap = mapBuilder.build();
    }

    @Override
    protected Set<Class<? extends M>> discoverModules() {
        return this.moduleMap.keySet();
    }

    @Override
    protected M constructModule(ModuleMetadata spec) throws Exception {
        Module module = (Module)this.moduleMap.get(spec.getModuleClass());
        if (module == null) {
            throw new NoModuleException(spec.getName());
        }
        return (M)module;
    }

    public static class Builder<M extends Module, D extends M>
    extends ModuleHolder.Builder<M, D, ProvidedModuleHolder<M, D>, Builder<M, D>> {
        private Set<M> modules;

        Builder(Class<M> moduleType, Class<D> disableType) {
            super(moduleType, disableType);
        }

        public Builder<M, D> setModules(Set<M> modules) {
            Preconditions.checkNotNull(modules);
            Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0);
            this.modules = modules;
            return this;
        }

        @Override
        protected Builder<M, D> getThis() {
            return this;
        }

        @Override
        public ProvidedModuleHolder<M, D> build() throws Exception {
            Preconditions.checkNotNull(this.modules);
            Preconditions.checkState((!this.modules.isEmpty() ? 1 : 0) != 0);
            this.checkBuild();
            return new ProvidedModuleHolder(this);
        }
    }
}

