/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.interfaces;

import com.google.gson.JsonObject;
import com.google.inject.ImplementedBy;
import io.github.nucleuspowered.nucleus.services.impl.storage.StorageManager;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IGeneralDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IWorldDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.standard.IKitDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.queryobjects.IUserQueryObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.queryobjects.IWorldQueryObject;
import io.github.nucleuspowered.storage.dataaccess.IDataTranslator;
import io.github.nucleuspowered.storage.persistence.IStorageRepository;
import io.github.nucleuspowered.storage.services.IStorageService;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

@ImplementedBy(value=StorageManager.class)
public interface IStorageManager {
    public IStorageService.SingleCached<IGeneralDataObject> getGeneralService();

    public IStorageService.SingleCached<IKitDataObject> getKitsService();

    public IStorageService.Keyed.KeyedData<UUID, IUserQueryObject, IUserDataObject> getUserService();

    public IStorageService.Keyed.KeyedData<UUID, IWorldQueryObject, IWorldDataObject> getWorldService();

    public IDataTranslator<IUserDataObject, JsonObject> getUserDataAccess();

    public IDataTranslator<IWorldDataObject, JsonObject> getWorldDataAccess();

    public IDataTranslator<IGeneralDataObject, JsonObject> getGeneralDataAccess();

    public IDataTranslator<IKitDataObject, JsonObject> getKitsDataAccess();

    public IStorageRepository.Keyed<UUID, IUserQueryObject, JsonObject> getUserRepository();

    public IStorageRepository.Keyed<UUID, IWorldQueryObject, JsonObject> getWorldRepository();

    public IStorageRepository.Single<JsonObject> getGeneralRepository();

    public IStorageRepository.Single<JsonObject> getKitsRepository();

    public CompletableFuture<Void> saveAndInvalidateAllCaches();

    default public CompletableFuture<IUserDataObject> getOrCreateUser(UUID uuid) {
        return this.getUserService().getOrNew(uuid);
    }

    default public IUserDataObject getOrCreateUserOnThread(UUID uuid) {
        return (IUserDataObject)this.getUserService().getOrNewOnThread(uuid);
    }

    default public CompletableFuture<Optional<IUserDataObject>> getUser(UUID uuid) {
        return this.getUserService().get((IUserQueryObject)((Object)uuid));
    }

    default public Optional<IUserDataObject> getUserOnThread(UUID uuid) {
        return this.getUserService().getOnThread(uuid);
    }

    default public CompletableFuture<Void> saveUser(UUID uuid, IUserDataObject object) {
        return this.getUserService().save(uuid, object);
    }

    default public Optional<IWorldDataObject> getWorldOnThread(UUID uuid) {
        return this.getWorldService().getOnThread(uuid);
    }

    default public IWorldDataObject getOrCreateWorldOnThread(UUID uuid) {
        return (IWorldDataObject)this.getWorldService().getOrNewOnThread(uuid);
    }

    default public IGeneralDataObject getGeneral() {
        IStorageService.SingleCached<IGeneralDataObject> gs = this.getGeneralService();
        return gs.getCached().orElseGet(() -> (IGeneralDataObject)gs.getOrNew().join());
    }

    default public IKitDataObject getKits() {
        IStorageService.SingleCached<IKitDataObject> gs = this.getKitsService();
        return gs.getCached().orElseGet(() -> (IKitDataObject)gs.getOrNew().join());
    }

    public CompletableFuture<Void> saveAll();
}

